/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConstantIfStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConstantIfStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantIfStatementFix();
    }

    private static class ConflictingDeclarationVisitor
    extends JavaRecursiveElementVisitor {
        private final String variableName;
        private final PsiCodeBlock exceptBlock;
        private boolean hasConflictingDeclaration = false;

        ConflictingDeclarationVisitor(String variableName, PsiCodeBlock exceptBlock) {
            this.variableName = variableName;
            this.exceptBlock = exceptBlock;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/ConstantIfStatementInspection$ConflictingDeclarationVisitor.visitElement must not be null");
            }
            if (!this.hasConflictingDeclaration) {
                super.visitElement(element);
            }
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            if (this.hasConflictingDeclaration) {
                return;
            }
            if (block.equals(this.exceptBlock)) {
                return;
            }
            super.visitCodeBlock(block);
        }

        public void visitVariable(PsiVariable variable) {
            if (this.hasConflictingDeclaration) {
                return;
            }
            super.visitVariable(variable);
            String name = variable.getName();
            if (name != null && name.equals(this.variableName)) {
                this.hasConflictingDeclaration = true;
            }
        }

        public boolean hasConflictingDeclaration() {
            return this.hasConflictingDeclaration;
        }
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (BoolUtils.isTrue(condition) || BoolUtils.isFalse(condition)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }
    }

    private static class ConstantIfStatementFix
    extends InspectionGadgetsFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConstantIfStatementInspection$ConstantIfStatementFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeyword.getParent();
            assert (statement != null);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            PsiExpression condition = statement.getCondition();
            if (BoolUtils.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement);
                } else {
                    ConstantIfStatementFix.deleteElement((PsiElement)statement);
                }
            } else {
                ConstantIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement);
            }
        }

        private static void replaceStatementWithUnwrapping(PsiStatement branch, PsiIfStatement statement) throws IncorrectOperationException {
            if (branch instanceof PsiBlockStatement && !(statement.getParent() instanceof PsiIfStatement)) {
                PsiCodeBlock parentBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)branch, PsiCodeBlock.class);
                if (parentBlock == null) {
                    String elseText = branch.getText();
                    ConstantIfStatementFix.replaceStatement((PsiStatement)statement, elseText);
                    return;
                }
                PsiCodeBlock block = ((PsiBlockStatement)branch).getCodeBlock();
                boolean hasConflicts = ConstantIfStatementFix.containsConflictingDeclarations(block, parentBlock);
                if (hasConflicts) {
                    String elseText = branch.getText();
                    ConstantIfStatementFix.replaceStatement((PsiStatement)statement, elseText);
                } else {
                    PsiElement containingElement = statement.getParent();
                    PsiStatement[] statements = block.getStatements();
                    if (statements.length > 0) {
                        assert (containingElement != null);
                        PsiElement added = containingElement.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)statement);
                        Project project = statement.getProject();
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                        codeStyleManager.reformat(added);
                    }
                    statement.delete();
                }
            } else {
                String elseText = branch.getText();
                ConstantIfStatementFix.replaceStatement((PsiStatement)statement, elseText);
            }
        }

        private static boolean containsConflictingDeclarations(PsiCodeBlock block, PsiCodeBlock parentBlock) {
            PsiStatement[] statements = block.getStatements();
            HashSet<PsiElement> declaredVars = new HashSet<PsiElement>();
            for (PsiStatement statement : statements) {
                PsiElement[] vars;
                if (!(statement instanceof PsiDeclarationStatement)) continue;
                PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
                for (PsiElement var : vars = declaration.getDeclaredElements()) {
                    if (!(var instanceof PsiLocalVariable)) continue;
                    declaredVars.add(var);
                }
            }
            for (PsiElement declaredVar : declaredVars) {
                PsiLocalVariable variable = (PsiLocalVariable)declaredVar;
                String variableName = variable.getName();
                if (!ConstantIfStatementFix.conflictingDeclarationExists(variableName, parentBlock, block)) continue;
                return true;
            }
            return false;
        }

        private static boolean conflictingDeclarationExists(String name, PsiCodeBlock parentBlock, PsiCodeBlock exceptBlock) {
            ConflictingDeclarationVisitor visitor = new ConflictingDeclarationVisitor(name, exceptBlock);
            parentBlock.accept((PsiElementVisitor)visitor);
            return visitor.hasConflictingDeclaration();
        }
    }
}

