/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import org.jetbrains.annotations.NotNull;

class CallToSuperCloneVisitor
extends JavaRecursiveElementVisitor {
    private boolean callToSuperCloneFound = false;

    CallToSuperCloneVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CallToSuperCloneVisitor.visitElement must not be null");
        }
        if (this.callToSuperCloneFound) {
            return;
        }
        super.visitElement(element);
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CallToSuperCloneVisitor.visitMethodCallExpression must not be null");
        }
        if (this.callToSuperCloneFound) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression target = methodExpression.getQualifierExpression();
        if (!(target instanceof PsiSuperExpression)) {
            return;
        }
        String methodName = methodExpression.getReferenceName();
        if (!"clone".equals(methodName)) {
            return;
        }
        this.callToSuperCloneFound = true;
    }

    public boolean isCallToSuperCloneFound() {
        return this.callToSuperCloneFound;
    }
}

