/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PublicConstructorInNonPublicClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.problem.descriptor", method.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorInNonPublicClassVisitor();
    }

    @Override
    @NotNull
    public InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiMethod constructor = (PsiMethod)infos[0];
        PsiClass aClass = constructor.getContainingClass();
        if (aClass.hasModifierProperty("protected")) {
            fixes.add(new SetConstructorModifierFix("protected"));
        } else if (aClass.hasModifierProperty("private")) {
            fixes.add(new SetConstructorModifierFix("private"));
        }
        fixes.add(new RemoveModifierFix("public"));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    private static class PublicConstructorInNonPublicClassVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorInNonPublicClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$PublicConstructorInNonPublicClassVisitor.visitMethod must not be null");
            }
            if (!method.isConstructor()) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("public")) {
                return;
            }
            if (SerializationUtils.isExternalizable(containingClass) && (parameterList = method.getParameterList()).getParametersCount() == 0) {
                return;
            }
            this.registerModifierError("public", (PsiModifierListOwner)method, method);
        }
    }

    private static class SetConstructorModifierFix
    extends InspectionGadgetsFix {
        @Modifier
        private final String modifier;

        SetConstructorModifierFix(@Modifier String modifier) {
            this.modifier = modifier;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.quickfix", this.modifier);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$SetConstructorModifierFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)element.getParent();
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty(this.modifier, true);
        }
    }
}

