/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VariableNotUsedInsideIfInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("variable.not.used.inside.if.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("variable.not.used.inside.if.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VariableNotUsedInsideIfVisitor();
    }

    private static class VariableNotUsedInsideIfVisitor
    extends BaseInspectionVisitor {
        private VariableNotUsedInsideIfVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression condition = expression.getCondition();
            if (!(condition instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQEQ) {
                PsiExpression elseBranch = expression.getElseExpression();
                this.checkReferences(rhs, lhs, (PsiElement)elseBranch);
            } else if (tokenType == JavaTokenType.NE) {
                PsiExpression thenBranch = expression.getThenExpression();
                this.checkReferences(rhs, lhs, (PsiElement)thenBranch);
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (!(condition instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQEQ) {
                PsiStatement thenBranch = statement.getThenBranch();
                if (VariableNotUsedInsideIfVisitor.contextExits((PsiElement)thenBranch)) {
                    return;
                }
                PsiStatement elseBranch = statement.getElseBranch();
                if (VariableNotUsedInsideIfVisitor.contextExits((PsiElement)elseBranch)) {
                    return;
                }
                this.checkReferences(rhs, lhs, (PsiElement)elseBranch);
            } else if (tokenType == JavaTokenType.NE) {
                PsiStatement thenBranch = statement.getThenBranch();
                if (VariableNotUsedInsideIfVisitor.contextExits((PsiElement)thenBranch)) {
                    return;
                }
                this.checkReferences(rhs, lhs, (PsiElement)thenBranch);
            }
        }

        private void checkReferences(PsiExpression left, PsiExpression right, PsiElement context) {
            if (context == null) {
                return;
            }
            if ("null".equals(left.getText())) {
                this.checkReferences(right, context);
            } else if ("null".equals(right.getText())) {
                this.checkReferences(left, context);
            }
        }

        private void checkReferences(PsiExpression expression, PsiElement context) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            if (VariableAccessUtils.variableIsUsed(variable, context)) {
                return;
            }
            this.registerError((PsiElement)referenceExpression, new Object[0]);
        }

        private static boolean contextExits(PsiElement context) {
            if (context instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)context;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return true;
                }
                PsiStatement lastStatement = statements[statements.length - 1];
                return VariableNotUsedInsideIfVisitor.statementExits((PsiElement)lastStatement);
            }
            return VariableNotUsedInsideIfVisitor.statementExits(context);
        }

        private static boolean statementExits(PsiElement context) {
            return context instanceof PsiReturnStatement || context instanceof PsiThrowStatement || context instanceof PsiBreakStatement || context instanceof PsiContinueStatement;
        }
    }
}

