/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.WellFormednessUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ObjectToStringInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("default.tostring.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ObjectToStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("default.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ObjectToStringInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectToStringVisitor();
    }

    private static class ObjectToStringVisitor
    extends BaseInspectionVisitor {
        private ObjectToStringVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ObjectToStringInspection$ObjectToStringVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            this.checkExpression(lhs);
            PsiExpression rhs = expression.getROperand();
            this.checkExpression(rhs);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ObjectToStringInspection$ObjectToStringVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(expression);
            if (!WellFormednessUtils.isWellFormed(expression)) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            PsiType type = lhs.getType();
            if (type == null) {
                return;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            PsiExpression rhs = expression.getRExpression();
            this.checkExpression(rhs);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"toString".equals(name)) {
                return;
            }
            PsiExpressionList argList = expression.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            this.checkExpression(qualifier);
        }

        private void checkExpression(PsiExpression expression) {
            if (expression == null) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (type instanceof PsiArrayType) {
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            if (type.equalsToText("java.lang.Object")) {
                return;
            }
            PsiClass referencedClass = classType.resolve();
            if (referencedClass == null || referencedClass instanceof PsiTypeParameter) {
                return;
            }
            if (referencedClass.isEnum() || referencedClass.isInterface()) {
                return;
            }
            if (ObjectToStringVisitor.hasGoodToString(referencedClass, new HashSet<PsiClass>())) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean hasGoodToString(PsiClass aClass, Set<PsiClass> visitedClasses) {
            PsiMethod[] methods;
            if (aClass == null) {
                return false;
            }
            if (!visitedClasses.add(aClass)) {
                return true;
            }
            String className = aClass.getQualifiedName();
            if ("java.lang.Object".equals(className)) {
                return false;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!ObjectToStringVisitor.isToString(method)) continue;
                return true;
            }
            PsiClass superClass = aClass.getSuperClass();
            return ObjectToStringVisitor.hasGoodToString(superClass, visitedClasses);
        }

        private static boolean isToString(PsiMethod method) {
            String methodName = method.getName();
            if (!"toString".equals(methodName)) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            return parameterList.getParametersCount() == 0;
        }
    }
}

