/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMayBeWeakenedInspection
extends BaseInspection {
    public boolean useRighthandTypeAsWeakestTypeInAssignments = true;
    public boolean useParameterizedTypeForCollectionMethods = true;
    public boolean doNotWeakenToJavaLangObject = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.may.be.weakened.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        Object info;
        Iterable weakerClasses = (Iterable)infos[1];
        StringBuilder builder = new StringBuilder();
        Iterator iterator = weakerClasses.iterator();
        if (iterator.hasNext()) {
            builder.append('\'');
            builder.append(((PsiClass)iterator.next()).getQualifiedName());
            builder.append('\'');
            while (iterator.hasNext()) {
                builder.append(", '");
                builder.append(((PsiClass)iterator.next()).getQualifiedName());
                builder.append('\'');
            }
        }
        if ((info = infos[0]) instanceof PsiField) {
            string = InspectionGadgetsBundle.message("type.may.be.weakened.field.problem.descriptor", builder.toString());
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection.buildErrorString must not return null");
            return string;
        }
        if (info instanceof PsiParameter) {
            string = InspectionGadgetsBundle.message("type.may.be.weakened.parameter.problem.descriptor", builder.toString());
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection.buildErrorString must not return null");
            return string;
        }
        if (info instanceof PsiMethod) {
            string = InspectionGadgetsBundle.message("type.may.be.weakened.method.problem.descriptor", builder.toString());
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("type.may.be.weakened.problem.descriptor", builder.toString());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection.buildErrorString must not return null");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.ignore.option", new Object[0]), "useRighthandTypeAsWeakestTypeInAssignments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.collection.method.option", new Object[0]), "useParameterizedTypeForCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("type.may.be.weakened.do.not.weaken.to.object.option", new Object[0]), "doNotWeakenToJavaLangObject");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Iterable weakerClasses = (Iterable)infos[1];
        ArrayList<TypeMayBeWeakenedFix> fixes = new ArrayList<TypeMayBeWeakenedFix>();
        for (PsiClass weakestClass : weakerClasses) {
            String qualifiedName = weakestClass.getQualifiedName();
            if (qualifiedName == null) continue;
            fixes.add(new TypeMayBeWeakenedFix(qualifiedName));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeMayBeWeakenedVisitor();
    }

    private class TypeMayBeWeakenedVisitor
    extends BaseInspectionVisitor {
        private TypeMayBeWeakenedVisitor() {
        }

        public void visitVariable(PsiVariable variable) {
            PsiExpression initializer;
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue;
            PsiElement parent;
            super.visitVariable(variable);
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                PsiElement declarationScope = parameter.getDeclarationScope();
                if (declarationScope instanceof PsiCatchSection) {
                    return;
                }
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null || containingClass.isInterface()) {
                        return;
                    }
                    Query superSearch = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false);
                    if (superSearch.findFirst() != null) {
                        return;
                    }
                    Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method);
                    if (overridingSearch.findFirst() != null) {
                        return;
                    }
                }
            }
            if (this.isOnTheFly() && variable instanceof PsiField && !variable.hasModifierProperty("private")) {
                return;
            }
            if (TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments && (variable instanceof PsiParameter ? (parent = variable.getParent()) instanceof PsiForeachStatement && !((iteratedValue = (foreachStatement = (PsiForeachStatement)parent).getIteratedValue()) instanceof PsiNewExpression) && !(iteratedValue instanceof PsiTypeCastExpression) : !((initializer = variable.getInitializer()) instanceof PsiNewExpression) && !(initializer instanceof PsiTypeCastExpression))) {
                return;
            }
            Collection<PsiClass> weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary((PsiElement)variable, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                Project project = variable.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", variable.getResolveScope());
                weakestClasses.remove(javaLangObjectClass);
            }
            if (weakestClasses.isEmpty()) {
                return;
            }
            this.registerVariableError(variable, variable, weakestClasses);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (this.isOnTheFly() && !method.hasModifierProperty("private")) {
                return;
            }
            Query superSearch = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false);
            if (superSearch.findFirst() != null) {
                return;
            }
            Query overridingSearch = OverridingMethodsSearch.search((PsiMethod)method);
            if (overridingSearch.findFirst() != null) {
                return;
            }
            Collection<PsiClass> weakestClasses = WeakestTypeFinder.calculateWeakestClassesNecessary((PsiElement)method, TypeMayBeWeakenedInspection.this.useRighthandTypeAsWeakestTypeInAssignments, TypeMayBeWeakenedInspection.this.useParameterizedTypeForCollectionMethods);
            if (TypeMayBeWeakenedInspection.this.doNotWeakenToJavaLangObject) {
                Project project = method.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass javaLangObjectClass = facade.findClass("java.lang.Object", method.getResolveScope());
                weakestClasses.remove(javaLangObjectClass);
            }
            if (weakestClasses.isEmpty()) {
                return;
            }
            this.registerMethodError(method, method, weakestClasses);
        }
    }

    private static class TypeMayBeWeakenedFix
    extends InspectionGadgetsFix {
        private final String fqClassName;

        TypeMayBeWeakenedFix(@NotNull String fqClassName) {
            if (fqClassName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedFix.<init> must not be null");
            }
            this.fqClassName = fqClassName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("type.may.be.weakened.quickfix", this.fqClassName);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/TypeMayBeWeakenedInspection$TypeMayBeWeakenedFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiClassType type;
            PsiTypeElement typeElement;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                typeElement = variable.getTypeElement();
            } else if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                typeElement = method.getReturnTypeElement();
            } else {
                return;
            }
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement componentReferenceElement = typeElement.getInnermostComponentReferenceElement();
            if (componentReferenceElement == null) {
                return;
            }
            PsiType oldType = typeElement.getType();
            if (!(oldType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)oldType;
            PsiType[] parameterTypes = classType.getParameters();
            GlobalSearchScope scope = element.getResolveScope();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass aClass = facade.findClass(this.fqClassName, scope);
            if (aClass == null) {
                return;
            }
            PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
            PsiElementFactory factory = facade.getElementFactory();
            if (typeParameters.length != 0 && typeParameters.length == parameterTypes.length) {
                HashMap<PsiTypeParameter, PsiType> typeParameterMap = new HashMap<PsiTypeParameter, PsiType>();
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeParameter typeParameter = typeParameters[i];
                    PsiType parameterType = parameterTypes[i];
                    typeParameterMap.put(typeParameter, parameterType);
                }
                PsiSubstitutor substitutor = factory.createSubstitutor(typeParameterMap);
                type = factory.createType(aClass, substitutor);
            } else {
                type = factory.createTypeByFQClassName(this.fqClassName, scope);
            }
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(type);
            componentReferenceElement.replace((PsiElement)referenceElement);
        }
    }
}

