/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.SplitterFactory;
import com.intellij.spellchecker.tokenizer.Token;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeTokenizer
extends Tokenizer<PsiTypeElement> {
    @Nullable
    public Token[] tokenize(@NotNull PsiTypeElement element) {
        Token[] tokenArray;
        boolean isInSource;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/PsiTypeTokenizer.tokenize must not be null");
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)element.getType());
        if (psiClass == null || psiClass.getContainingFile() == null || psiClass.getContainingFile().getVirtualFile() == null) {
            return null;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        boolean bl = isInSource = virtualFile != null && fileIndex.isInContent(virtualFile);
        if (!isInSource) {
            tokenArray = null;
        } else {
            Token[] tokenArray2 = new Token[1];
            tokenArray = tokenArray2;
            tokenArray2[0] = new Token((PsiElement)element, element.getText(), true, 0, this.getRangeToCheck(element.getText(), psiClass.getName()), (Splitter)SplitterFactory.getInstance().getIdentifierSplitter());
        }
        return tokenArray;
    }

    @NotNull
    private TextRange getRangeToCheck(@NotNull String text, @NotNull String name) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/PsiTypeTokenizer.getRangeToCheck must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/PsiTypeTokenizer.getRangeToCheck must not be null");
        }
        int i = text.indexOf(name);
        TextRange textRange = new TextRange(i, i + name.length());
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/PsiTypeTokenizer.getRangeToCheck must not return null");
        }
        return textRange;
    }
}

