/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaI18nUtil
extends I18nUtil {
    public static final PropertyCreationHandler DEFAULT_PROPERTY_CREATION_HANDLER = new PropertyCreationHandler(){

        @Override
        public void createProperty(Project project, Collection<PropertiesFile> propertiesFiles, String key, String value, PsiExpression[] parameters) throws IncorrectOperationException {
            JavaI18nUtil.createProperty((Project)project, propertiesFiles, (String)key, (String)value);
        }
    };

    private JavaI18nUtil() {
    }

    public static boolean mustBePropertyKey(PsiLiteralExpression expression, @NotNull Map<String, Object> annotationAttributeValues) {
        if (annotationAttributeValues == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/i18n/JavaI18nUtil.mustBePropertyKey must not be null");
        }
        return JavaI18nUtil.isPassedToAnnotatedParam((PsiExpression)expression, "org.jetbrains.annotations.PropertyKey", annotationAttributeValues, null);
    }

    public static boolean isPassedToAnnotatedParam(PsiExpression expression, String annFqn, @NotNull Map<String, Object> annotationAttributeValues, @Nullable Set<PsiModifierListOwner> nonNlsTargets) {
        PsiMethod method;
        if (annotationAttributeValues == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/i18n/JavaI18nUtil.isPassedToAnnotatedParam must not be null");
        }
        PsiElement parent = (expression = JavaI18nUtil.getToplevelExpression(expression)).getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        int idx = -1;
        PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = args[i];
            if (!PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)expression, (boolean)false)) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return false;
        }
        PsiElement grParent = parent.getParent();
        if (grParent instanceof PsiAnonymousClass) {
            grParent = grParent.getParent();
        }
        return grParent instanceof PsiCall && (method = ((PsiCall)grParent).resolveMethod()) != null && JavaI18nUtil.isMethodParameterAnnotatedWith(method, idx, (Collection<PsiMethod>)new THashSet(), annFqn, annotationAttributeValues, nonNlsTargets);
    }

    public static PsiExpression getToplevelExpression(PsiExpression expression) {
        PsiExpression parent;
        while (!(!(expression.getParent() instanceof PsiExpression) || (parent = (PsiExpression)expression.getParent()) instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == expression || (expression = parent) instanceof PsiAssignmentExpression)) {
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMethodParameterAnnotatedWith(PsiMethod method, int idx, Collection<PsiMethod> processed, String annFqn, @NotNull Map<String, Object> annotationAttributeValues, @Nullable Set<PsiModifierListOwner> nonNlsTargets) {
        PsiMethod[] superMethods;
        PsiAnnotation annotation;
        PsiParameter param;
        if (annotationAttributeValues == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInspection/i18n/JavaI18nUtil.isMethodParameterAnnotatedWith must not be null");
        }
        if (processed.contains(method)) {
            return false;
        }
        processed.add(method);
        PsiParameter[] params = method.getParameterList().getParameters();
        if (idx >= params.length) {
            if (params.length == 0) {
                return false;
            }
            PsiParameter lastParam = params[params.length - 1];
            if (!lastParam.isVarArgs()) return false;
            param = lastParam;
        } else {
            param = params[idx];
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)param, (String[])new String[]{annFqn})) != null) {
            PsiNameValuePair[] attributes;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameterList.getAttributes()) {
                String name = attribute.getName();
                if (!annotationAttributeValues.containsKey(name)) continue;
                annotationAttributeValues.put(name, attribute.getValue());
            }
            return true;
        }
        if (nonNlsTargets != null) {
            nonNlsTargets.add((PsiModifierListOwner)param);
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            if (!JavaI18nUtil.isMethodParameterAnnotatedWith(superMethod, idx, processed, annFqn, annotationAttributeValues, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidPropertyReference(PsiLiteralExpression expression, String key, Ref<String> outResourceBundle) {
        HashMap annotationAttributeValues = new HashMap();
        annotationAttributeValues.put((Object)"resourceBundle", null);
        if (JavaI18nUtil.mustBePropertyKey(expression, (Map<String, Object>)annotationAttributeValues)) {
            Object resourceBundleName = annotationAttributeValues.get((Object)"resourceBundle");
            if (!(resourceBundleName instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)resourceBundleName;
            Object value = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr);
            if (value == null) {
                return false;
            }
            String bundleName = value.toString();
            outResourceBundle.set((Object)bundleName);
            return JavaI18nUtil.isPropertyRef(expression, key, bundleName);
        }
        return true;
    }

    public static boolean isPropertyRef(PsiLiteralExpression expression, String key, String resourceBundleName) {
        if (resourceBundleName == null) {
            return !PropertiesUtil.findPropertiesByKey((Project)expression.getProject(), (String)key).isEmpty();
        }
        List propertiesFiles = JavaI18nUtil.propertiesFilesByBundleName((String)resourceBundleName, (PsiElement)expression);
        boolean containedInPropertiesFile = false;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            containedInPropertiesFile |= propertiesFile.findPropertyByKey(key) != null;
        }
        return containedInPropertiesFile;
    }

    public static Set<String> suggestExpressionOfType(PsiClassType type, PsiLiteralExpression context) {
        PsiExpression[] expressions;
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt((PsiElement)context, (String)"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiVariable var : variables) {
            PsiType varType = var.getType();
            if (type != null && !type.isAssignableFrom(varType)) continue;
            result.add(var.getNameIdentifier().getText());
        }
        for (PsiExpression expression : expressions = MacroUtil.getStandardExpressionsOfType((PsiElement)context, (PsiType)type)) {
            result.add(expression.getText());
        }
        if (type != null) {
            JavaI18nUtil.addAvailableMethodsOfType(type, context, result);
        }
        return result;
    }

    private static void addAvailableMethodsOfType(final PsiClassType type, PsiLiteralExpression context, final Collection<String> result) {
        PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new PsiScopeProcessor(){

            public boolean execute(PsiElement element, ResolveState state) {
                PsiMethod method;
                PsiType returnType;
                if (element instanceof PsiMethod && (returnType = (method = (PsiMethod)element).getReturnType()) != null && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)returnType) && method.getParameterList().getParametersCount() == 0) {
                    result.add(method.getName() + "()");
                }
                return true;
            }

            public <T> T getHint(Key<T> hintKey) {
                return null;
            }

            public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
            }
        }, (PsiElement)context, null);
    }

    public static int getPropertyValueParamsMaxCount(PsiLiteralExpression expression) {
        int maxCount = -1;
        for (PsiReference reference : expression.getReferences()) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                MessageFormat format;
                if (!result.isValidResult() || !(result.getElement() instanceof Property)) continue;
                String value = ((Property)result.getElement()).getValue();
                try {
                    format = new MessageFormat(value);
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    int count = format.getFormatsByArgumentIndex().length;
                    maxCount = Math.max(maxCount, count);
                }
                catch (IllegalArgumentException ignored) {
                    // empty catch block
                }
            }
        }
        return maxCount;
    }
}

