/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyRunConfigurationEditor;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GroovyScriptRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule> {
    public String vmParams;
    public String workDir;
    public boolean isDebugEnabled;
    public String scriptParams;
    @Nullable
    public String scriptPath;

    public GroovyScriptRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, new RunConfigurationModule(project), factory);
        this.workDir = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    protected ModuleBasedConfiguration createInstance() {
        return new GroovyScriptRunConfiguration(this.getName(), this.getProject(), this.getFactory());
    }

    public void setWorkDir(String dir) {
        this.workDir = dir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    private String getAbsoluteWorkDir() {
        if (!FileUtil.isAbsolute((String)this.workDir)) {
            return new File(this.getProject().getLocation(), this.workDir).getAbsolutePath();
        }
        return this.workDir;
    }

    public Collection<Module> getValidModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        GroovyScriptRunner scriptRunner = this.findConfiguration();
        if (scriptRunner == null) {
            return Arrays.asList(modules);
        }
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (!scriptRunner.isValidModule(module)) continue;
            res.add(module);
        }
        return res;
    }

    @Nullable
    private GroovyScriptRunner findConfiguration() {
        VirtualFile scriptFile = this.getScriptFile();
        if (scriptFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(scriptFile);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        if (!((GroovyFile)psiFile).isScript()) {
            return new DefaultGroovyScriptRunner();
        }
        return GroovyScriptType.getScriptType((GroovyFile)psiFile).getRunner();
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.readModule(element);
        this.scriptPath = JDOMExternalizer.readString((Element)element, (String)"path");
        this.vmParams = JDOMExternalizer.readString((Element)element, (String)"vmparams");
        this.scriptParams = JDOMExternalizer.readString((Element)element, (String)"params");
        String wrk = JDOMExternalizer.readString((Element)element, (String)"workDir");
        if (!".".equals(wrk)) {
            this.workDir = wrk;
        }
        this.isDebugEnabled = Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)"debug"));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        JDOMExternalizer.write((Element)element, (String)"path", (String)this.scriptPath);
        JDOMExternalizer.write((Element)element, (String)"vmparams", (String)this.vmParams);
        JDOMExternalizer.write((Element)element, (String)"params", (String)this.scriptParams);
        JDOMExternalizer.write((Element)element, (String)"workDir", (String)this.workDir);
        JDOMExternalizer.write((Element)element, (String)"debug", (boolean)this.isDebugEnabled);
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration.getState must not be null");
        }
        if (environment == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration.getState must not be null");
        }
        final VirtualFile script = this.getScriptFile();
        if (script == null) {
            throw new CantRunException("Cannot find script " + this.scriptPath);
        }
        final GroovyScriptRunner scriptRunner = this.findConfiguration();
        if (scriptRunner == null) {
            throw new CantRunException("Unknown script type " + this.scriptPath);
        }
        final Module module = this.getModule();
        if (!scriptRunner.ensureRunnerConfigured(module, this.getName(), this.getProject())) {
            return null;
        }
        final boolean tests = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInTestSourceContent(script);
        JavaCommandLineState state = new JavaCommandLineState(environment){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                JavaParameters params = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
                params.setWorkingDirectory(GroovyScriptRunConfiguration.this.getAbsoluteWorkDir());
                scriptRunner.configureCommandLine(params, module, tests, script, GroovyScriptRunConfiguration.this);
                return params;
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject()));
        return state;
    }

    public static JavaParameters createJavaParametersWithSdk(Module module) {
        Sdk sdk;
        JavaParameters params = new JavaParameters();
        params.setCharset(null);
        if (module != null && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdkType) {
            params.setJdk(sdk);
        }
        if (params.getJdk() == null) {
            params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        return params;
    }

    @Nullable
    private VirtualFile getScriptFile() {
        if (this.scriptPath == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.scriptPath));
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new GroovyRunConfigurationEditor();
    }
}

