/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GroovyRunConfigurationEditor
extends SettingsEditor<GroovyScriptRunConfiguration> {
    private DefaultComboBoxModel myModulesModel;
    private JComboBox myModulesBox;
    private JPanel myMainPanel;
    private RawCommandLineEditor myVMParameters;
    private RawCommandLineEditor myParameters;
    private JPanel scriptPathPanel;
    private JPanel workDirPanel;
    private JCheckBox myDebugCB;
    private final JTextField scriptPathField;
    private final JTextField workDirField;

    public GroovyRunConfigurationEditor() {
        this.$$$setupUI$$$();
        this.scriptPathField = new JTextField();
        BrowseFilesListener scriptBrowseListener = new BrowseFilesListener(this.scriptPathField, "Script Path", "Specify path to script", new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return file.getFileType() == GroovyFileType.GROOVY_FILE_TYPE;
            }
        });
        FieldPanel scriptFieldPanel = new FieldPanel(this.scriptPathField, "Script path:", null, (ActionListener)scriptBrowseListener, null);
        this.scriptPathPanel.setLayout(new BorderLayout());
        this.scriptPathPanel.add((Component)scriptFieldPanel, "Center");
        this.workDirField = new JTextField();
        BrowseFilesListener workDirBrowseFilesListener = new BrowseFilesListener(this.workDirField, "Working directory", "Specify working directory", BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        FieldPanel workDirFieldPanel = new FieldPanel(this.workDirField, "Working directory:", null, (ActionListener)workDirBrowseFilesListener, null);
        this.workDirPanel.setLayout(new BorderLayout());
        this.workDirPanel.add((Component)workDirFieldPanel, "Center");
    }

    public void resetEditorFrom(GroovyScriptRunConfiguration configuration) {
        this.myVMParameters.setDialogCaption("VM Parameters");
        this.myVMParameters.setText(configuration.vmParams);
        this.myParameters.setDialogCaption("Script Parameters");
        this.myParameters.setText(configuration.scriptParams);
        this.scriptPathField.setText(configuration.scriptPath);
        this.workDirField.setText(configuration.getWorkDir());
        this.myDebugCB.setEnabled(true);
        this.myDebugCB.setSelected(configuration.isDebugEnabled);
        this.myModulesModel.removeAllElements();
        for (Module module : configuration.getValidModules()) {
            this.myModulesModel.addElement(module);
        }
        this.myModulesModel.setSelectedItem(configuration.getModule());
    }

    public void applyEditorTo(GroovyScriptRunConfiguration configuration) throws ConfigurationException {
        configuration.setModule((Module)this.myModulesBox.getSelectedItem());
        configuration.vmParams = this.myVMParameters.getText();
        configuration.isDebugEnabled = this.myDebugCB.isSelected();
        configuration.scriptParams = this.myParameters.getText();
        configuration.scriptPath = this.scriptPathField.getText();
        configuration.setWorkDir(this.workDirField.getText());
    }

    @NotNull
    public JComponent createEditor() {
        this.myModulesModel = new DefaultComboBoxModel();
        this.myModulesBox.setModel(this.myModulesModel);
        this.myDebugCB.setEnabled(true);
        this.myDebugCB.setSelected(false);
        this.myModulesBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Module module = (Module)value;
                if (module != null) {
                    this.setIcon(module.getModuleType().getNodeIcon(false));
                    this.setText(module.getName());
                }
                return this;
            }
        });
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/runner/GroovyRunConfigurationEditor.createEditor must not return null");
        }
        return jPanel;
    }

    public void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Script Parameters:");
        jPanel3.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMParameters = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor2, new GridConstraints(4, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(6, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.scriptPathPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Module:");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModulesBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.workDirPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("VM Parameters:");
        jPanel3.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDebugCB = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/GroovyBundle").getString("debug.option"));
        jCheckBox.setSelected(false);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

