/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class PropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return PropertyRenameHandler.getProperty(dataContext) != null;
    }

    @Nullable
    private static GrField getProperty(DataContext dataContext) {
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof GrField && ((GrField)element).isProperty()) {
            return (GrField)element;
        }
        if (element instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)element).getProperty();
        }
        return null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return PropertyRenameHandler.getProperty(dataContext) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/rename/PropertyRenameHandler.invoke must not be null");
        }
        GrField property = PropertyRenameHandler.getProperty(dataContext);
        assert (property != null);
        new PropertyRenameDialog(property, editor).show();
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/rename/PropertyRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/rename/PropertyRenameHandler.invoke must not be null");
        }
        GrField property = PropertyRenameHandler.getProperty(dataContext);
        if (dataContext == null || property == null) {
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        new PropertyRenameDialog(property, editor).show();
    }

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final GrField myProperty;

        protected PropertyRenameDialog(GrField property, Editor editor) {
            super(property.getProject(), (PsiElement)property, null, editor);
            this.myProperty = property;
        }

        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            this.doRename(newName, searchInComments);
            this.close(0);
        }

        private void doRename(String newName, boolean searchInComments) {
            JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(this.myProperty.getProject(), (PsiElement)this.myProperty, newName, searchInComments, false);
            GrAccessorMethod setter = this.myProperty.getSetter();
            if (setter != null && !(setter instanceof GrAccessorMethod)) {
                String setterName = PropertyUtil.suggestSetterName((String)newName);
                rename.addElement((PsiElement)setter, setterName);
            }
            rename.run();
        }

        protected boolean areButtonsValid() {
            String newName = this.getNewName();
            return super.areButtonsValid() && !GroovyRefactoringUtil.KEYWORDS.contains(newName);
        }
    }
}

