/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesHandlerBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.refactoring.move.MoveGroovyScriptDialog;

public class MoveGroovyScriptHandler
extends MoveClassesOrPackagesHandlerBase {
    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return super.adjustForMove(project, sourceElements, targetElement);
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if (MoveGroovyScriptHandler.canMove(element)) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    private static boolean canMove(PsiElement element) {
        if (!(element instanceof GroovyFile)) {
            return false;
        }
        GroovyFile file = (GroovyFile)element;
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null || !ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInSource(vfile)) {
            return false;
        }
        PsiClass[] classes = file.getClasses();
        return classes.length == 1 && classes[0] instanceof GroovyScriptClass;
    }

    public boolean isValidTarget(PsiElement psiElement) {
        return MoveGroovyScriptHandler.isPackageOrDirectory((PsiElement)psiElement);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (MoveGroovyScriptHandler.canMove(element)) {
            this.doMove(project, new PsiElement[]{element}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        return false;
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements), (boolean)true)) {
            return;
        }
        String initialTargetPackageName = MoveClassesOrPackagesImpl.getInitialTargetPackageName((PsiElement)initialTargetElement, (PsiElement[])elements);
        PsiDirectory initialTargetDirectory = MoveClassesOrPackagesImpl.getInitialTargetDirectory((PsiElement)initialTargetElement, (PsiElement[])elements);
        boolean isTargetDirectoryFixed = MoveClassesOrPackagesImpl.getContainerDirectory((PsiElement)initialTargetElement) != null;
        boolean searchTextOccurences = false;
        for (int i = 0; i < elements.length && !searchTextOccurences; ++i) {
            PsiElement psiElement = elements[i];
            searchTextOccurences = TextOccurrencesUtil.isSearchTextOccurencesEnabled((PsiElement)psiElement);
        }
        MoveGroovyScriptDialog moveDialog = new MoveGroovyScriptDialog(project, searchTextOccurences, elements, initialTargetElement, moveCallback);
        boolean searchInComments = JavaRefactoringSettings.getInstance().MOVE_SEARCH_IN_COMMENTS;
        boolean searchForTextOccurences = JavaRefactoringSettings.getInstance().MOVE_SEARCH_FOR_TEXT;
        moveDialog.setData(elements, initialTargetPackageName, initialTargetDirectory, isTargetDirectoryFixed, searchInComments, searchForTextOccurences, HelpID.getMoveHelpID((PsiElement)elements[0]));
        moveDialog.show();
    }
}

