/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceVariable;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableDialog;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableSettings;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyVariableValidator;

public abstract class GroovyIntroduceVariableBase
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.refactoring.introduceVariable.groovyIntroduceVariableBase");
    protected static String REFACTORING_NAME = GroovyRefactoringBundle.message("introduce.variable.title", new Object[0]);
    private PsiElement positionElement = null;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyIntroduceVariableBase.invoke must not be null");
        }
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        GroovyRefactoringUtil.trimSpacesAndComments(editor, file, true);
        this.invoke(project, editor, file, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
    }

    private boolean invoke(Project project, Editor editor, PsiFile file, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!(file instanceof GroovyFileBase)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("only.in.groovy.files", new Object[0]));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        GrExpression tempExpr = GroovyRefactoringUtil.findElementInRange((GroovyFileBase)file, startOffset, endOffset, GrExpression.class);
        return this.invokeImpl(project, tempExpr, editor);
    }

    private boolean invokeImpl(Project project, GrExpression selectedExpr, Editor editor) {
        String[] stringArray;
        GroovyVariableValidator validator;
        PsiElement parent;
        if (selectedExpr == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("selected.block.should.represent.an.expression", new Object[0]));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        PsiFile file = selectedExpr.getContainingFile();
        LOG.assertTrue(file != null, (Object)"expr.getContainingFile() == null");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        PsiType type = selectedExpr.getType();
        if (type != null) {
            type = TypeConversionUtil.erasure((PsiType)type);
        }
        if (PsiType.VOID.equals(type)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("selected.expression.has.void.type", new Object[0]));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        for (parent = selectedExpr.getParent(); parent != null && !(parent instanceof GroovyFileBase) && !(parent instanceof GrParameter); parent = parent.getParent()) {
        }
        if (GroovyIntroduceVariableBase.checkInFieldInitializer(selectedExpr)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", new Object[0]));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        if (parent instanceof GrParameter) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("refactoring.is.not.supported.in.method.parameters", new Object[0]));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        PsiElement enclosingContainer = GroovyRefactoringUtil.getEnclosingContainer(selectedExpr);
        if (enclosingContainer == null || !(enclosingContainer instanceof GroovyPsiElement)) {
            return this.tempContainerNotFound(project);
        }
        GroovyPsiElement tempContainer = (GroovyPsiElement)enclosingContainer;
        if (!GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(tempContainer)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", REFACTORING_NAME));
            this.showErrorMessage(project, editor, message);
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return false;
        }
        PsiElement[] occurrences = GroovyRefactoringUtil.getExpressionOccurrences(GroovyRefactoringUtil.getUnparenthesizedExpr(selectedExpr), tempContainer);
        GroovyIntroduceVariableDialog dialog = this.getDialog(project, editor, selectedExpr, type, occurrences, false, validator = new GroovyVariableValidator(this, project, selectedExpr, occurrences, tempContainer));
        if (!dialog.isOK()) {
            return false;
        }
        GroovyIntroduceVariableSettings settings = dialog.getSettings();
        String varName = settings.getEnteredName();
        PsiType varType = settings.getSelectedType();
        boolean isFinal = settings.isDeclareFinal();
        boolean replaceAllOccurrences = settings.isReplaceAllOccurrences();
        if (isFinal) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "final";
        } else {
            stringArray = null;
        }
        GrVariableDeclaration varDecl = factory.createVariableDeclaration(stringArray, GroovyRefactoringUtil.getUnparenthesizedExpr(selectedExpr), varType, varName);
        this.runRefactoring(selectedExpr, editor, tempContainer, occurrences, varName, varType, replaceAllOccurrences, varDecl);
        return true;
    }

    private static boolean checkInFieldInitializer(GrExpression expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof GrClosableBlock) {
            return false;
        }
        if (parent instanceof GrField && expr == ((GrField)parent).getInitializerGroovy()) {
            return true;
        }
        if (parent instanceof GrExpression) {
            return GroovyIntroduceVariableBase.checkInFieldInitializer((GrExpression)parent);
        }
        return false;
    }

    void runRefactoring(final GrExpression selectedExpr, final Editor editor, final GroovyPsiElement tempContainer, final PsiElement[] occurrences, final String varName, final PsiType varType, final boolean replaceAllOccurrences, final GrVariableDeclaration varDecl) {
        Project project = selectedExpr.getProject();
        final GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        final Runnable runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    boolean alreadyDefined;
                    GroovyRefactoringUtil.sortOccurrences(occurrences);
                    if (occurrences.length == 0) throw new IncorrectOperationException("Wrong expression occurrence");
                    if (!(occurrences[0] instanceof GrExpression)) {
                        throw new IncorrectOperationException("Wrong expression occurrence");
                    }
                    GrExpression firstOccurrence = replaceAllOccurrences ? (GrExpression)occurrences[0] : selectedExpr;
                    assert (varDecl.getVariables().length > 0);
                    GroovyIntroduceVariableBase.this.resolveLocalConflicts(tempContainer, varDecl.getVariables()[0]);
                    GrVariable insertedVar = GroovyIntroduceVariableBase.this.replaceOnlyExpression(firstOccurrence, selectedExpr, tempContainer, varDecl);
                    boolean bl = alreadyDefined = insertedVar != null;
                    if (insertedVar == null) {
                        insertedVar = GroovyIntroduceVariableBase.this.insertVariableDefinition(tempContainer, selectedExpr, occurrences, replaceAllOccurrences, varDecl, factory);
                    }
                    insertedVar.setType(varType);
                    GrReferenceExpression refExpr = factory.createReferenceExpressionFromText(varName);
                    if (!replaceAllOccurrences) {
                        if (!alreadyDefined) {
                            if (selectedExpr instanceof GrClosableBlock && selectedExpr.getParent() instanceof GrMethodCallExpression) {
                                GroovyIntroduceVariableBase.this.refreshPositionMarker(((GrMethodCallExpression)selectedExpr.getParent()).replaceClosureArgument((GrClosableBlock)selectedExpr, refExpr));
                            } else {
                                GroovyIntroduceVariableBase.this.refreshPositionMarker(selectedExpr.replaceWithExpression(refExpr, true));
                            }
                        }
                    } else {
                        ArrayList<GrExpression> replaced = new ArrayList<GrExpression>();
                        for (PsiElement occurrence : occurrences) {
                            if (alreadyDefined && firstOccurrence.equals(occurrence)) continue;
                            if (!(occurrence instanceof GrExpression)) throw new IncorrectOperationException("Expression occurrence to be replaced is not instance of GroovyPsiElement");
                            GrExpression element = (GrExpression)occurrence;
                            if (element instanceof GrClosableBlock && element.getParent() instanceof GrMethodCallExpression) {
                                replaced.add(((GrMethodCallExpression)element.getParent()).replaceClosureArgument((GrClosableBlock)element, refExpr));
                            } else {
                                replaced.add(element.replaceWithExpression(refExpr, true));
                            }
                            if (occurrence.equals(selectedExpr)) {
                                GroovyIntroduceVariableBase.this.refreshPositionMarker((PsiElement)replaced.get(replaced.size() - 1));
                            }
                            refExpr = factory.createReferenceExpressionFromText(varName);
                        }
                        if (editor == null) {
                            // empty if block
                        }
                    }
                    if (editor == null) return;
                    if (GroovyIntroduceVariableBase.this.getPositionMarker() == null) return;
                    editor.getCaretModel().moveToOffset(GroovyIntroduceVariableBase.this.getPositionMarker().getTextRange().getEndOffset());
                    editor.getSelectionModel().removeSelection();
                    return;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, REFACTORING_NAME, null);
    }

    private void resolveLocalConflicts(PsiElement tempContainer, GrVariable varDef) {
        for (PsiElement child : tempContainer.getChildren()) {
            if (child instanceof GrReferenceExpression && !child.getText().contains(".")) {
                String fieldName;
                PsiElement resolved;
                PsiReference psiReference = child.getReference();
                if (psiReference == null || (resolved = psiReference.resolve()) == null || (fieldName = this.getFieldName(resolved)) == null || !varDef.getName().equals(fieldName)) continue;
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(tempContainer.getProject());
                ((GrReferenceExpression)child).replaceWithExpression(factory.createExpressionFromText("this." + child.getText()), true);
                continue;
            }
            this.resolveLocalConflicts(child, varDef);
        }
    }

    private String getFieldName(PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        return element instanceof GrField ? ((GrField)element).getName() : null;
    }

    private void refreshPositionMarker(PsiElement position) {
        if (this.positionElement == null && position != null) {
            this.positionElement = position;
        }
    }

    private PsiElement getPositionMarker() {
        return this.positionElement;
    }

    private GrVariable insertVariableDefinition(GroovyPsiElement tempContainer, GrExpression selectedExpr, PsiElement[] occurrences, boolean replaceAllOccurrences, GrVariableDeclaration varDecl, GroovyPsiElementFactory factory) throws IncorrectOperationException {
        LOG.assertTrue(occurrences.length > 0);
        GrStatement anchorElement = (GrStatement)GroovyRefactoringUtil.calculatePositionToInsertBefore(tempContainer, selectedExpr, occurrences, replaceAllOccurrences);
        LOG.assertTrue(anchorElement != null);
        PsiElement realContainer = anchorElement.getParent();
        assert (GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(realContainer));
        if (!(realContainer instanceof GrLoopStatement)) {
            if (realContainer instanceof GrStatementOwner) {
                GrStatementOwner block = (GrStatementOwner)realContainer;
                varDecl = (GrVariableDeclaration)block.addStatementBefore(varDecl, anchorElement);
            }
        } else {
            GrBlockStatement newBody;
            GrStatement tempStatement = anchorElement;
            boolean inThenIfBranch = realContainer instanceof GrIfStatement && anchorElement.equals(((GrIfStatement)realContainer).getThenBranch());
            String refId = varDecl.getVariables()[0].getName();
            if (tempStatement.equals(selectedExpr)) {
                newBody = factory.createBlockStatement(varDecl);
            } else {
                this.replaceExpressionOccurrencesInStatement(tempStatement, selectedExpr, refId, replaceAllOccurrences);
                newBody = factory.createBlockStatement(varDecl, tempStatement);
            }
            varDecl = (GrVariableDeclaration)newBody.getBlock().getStatements()[0];
            GrOpenBlock tempBlock = newBody.getBlock();
            if (realContainer instanceof GrLoopStatement) {
                tempBlock = ((GrBlockStatement)((GrLoopStatement)realContainer).replaceBody(newBody)).getBlock();
            } else if (realContainer instanceof GrIfStatement) {
                GrIfStatement ifStatement = (GrIfStatement)realContainer;
                tempBlock = inThenIfBranch ? ((GrBlockStatement)ifStatement.replaceThenBranch(newBody)).getBlock() : ((GrBlockStatement)ifStatement.replaceElseBranch(newBody)).getBlock();
            }
            this.refreshPositionMarker(tempBlock.getStatements()[tempBlock.getStatements().length - 1]);
        }
        return varDecl.getVariables()[0];
    }

    private void replaceExpressionOccurrencesInStatement(GrStatement stmt, GrExpression expr, String refText, boolean replaceAllOccurrences) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(stmt.getProject());
        GrReferenceExpression refExpr = factory.createReferenceExpressionFromText(refText);
        if (!replaceAllOccurrences) {
            expr.replaceWithExpression(refExpr, true);
        } else {
            PsiElement[] occurrences;
            for (PsiElement occurrence : occurrences = GroovyRefactoringUtil.getExpressionOccurrences(expr, stmt)) {
                if (!(occurrence instanceof GrExpression)) {
                    throw new IncorrectOperationException();
                }
                GrExpression grExpression = (GrExpression)occurrence;
                grExpression.replaceWithExpression(refExpr, true);
                refExpr = factory.createReferenceExpressionFromText(refText);
            }
        }
    }

    private GrVariable replaceOnlyExpression(@NotNull GrExpression expr, GrExpression selectedExpr, @NotNull PsiElement context, @NotNull GrVariableDeclaration definition) throws IncorrectOperationException {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyIntroduceVariableBase.replaceOnlyExpression must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyIntroduceVariableBase.replaceOnlyExpression must not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyIntroduceVariableBase.replaceOnlyExpression must not be null");
        }
        if (context.equals(expr.getParent()) && !(context instanceof GrLoopStatement) && !(context instanceof GrClosableBlock)) {
            definition = expr.replaceWithStatement(definition);
            if (expr.equals(selectedExpr)) {
                this.refreshPositionMarker(definition);
            }
            return definition.getVariables()[0];
        }
        return null;
    }

    private boolean tempContainerNotFound(Project project) {
        String message = GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", REFACTORING_NAME);
        this.showErrorMessage(project, null, message);
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyIntroduceVariableBase.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyIntroduceVariableBase.invoke must not be null");
        }
    }

    protected abstract GroovyIntroduceVariableDialog getDialog(Project var1, Editor var2, GrExpression var3, PsiType var4, PsiElement[] var5, boolean var6, Validator var7);

    protected abstract void showErrorMessage(Project var1, Editor var2, String var3);

    protected abstract void highlightOccurrences(Project var1, Editor var2, PsiElement[] var3);

    protected abstract boolean reportConflicts(ArrayList<String> var1, Project var2);

    public static interface Validator
    extends NameValidator {
        public boolean isOK(GroovyIntroduceVariableDialog var1);
    }
}

