/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;

public class GroovyChangeContextUtil {
    private static final Key<PsiClass> QUALIFIER_CLASS_KEY = Key.create((String)"QUALIFIER_CLASS_KEY");
    private static final Key<PsiClass> REF_TO_CLASS = Key.create((String)"REF_TO_CLASS");
    private static final Key<PsiMember> REF_TO_MEMBER = Key.create((String)"REF_TO_MEMBER");
    private static final Key<Object> KEY_ENCODED = Key.create((String)"KEY_ENCODED");

    public static void encodeContextInfo(PsiElement element) {
        if (!(element instanceof GroovyPsiElement)) {
            return;
        }
        if (element instanceof GrThisReferenceExpression) {
            GrThisReferenceExpression thisExpr = (GrThisReferenceExpression)element;
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)thisExpr, PsiClass.class);
            element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
            thisExpr.putCopyableUserData(QUALIFIER_CLASS_KEY, containingClass);
        } else if (element instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)element;
            GrExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier == null) {
                PsiElement refElement = refExpr.resolve();
                if (refElement instanceof GrAccessorMethod) {
                    refElement = ((GrAccessorMethod)refElement).getProperty();
                }
                if (refElement instanceof PsiClass) {
                    refExpr.putCopyableUserData(REF_TO_CLASS, (PsiClass)refElement);
                    element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
                } else if (refElement instanceof PsiMember) {
                    refExpr.putCopyableUserData(REF_TO_MEMBER, (PsiMember)refElement);
                    element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
                }
            }
        } else {
            PsiElement resolvedElement;
            PsiReference ref = element.getReference();
            if (ref != null && (resolvedElement = ref.resolve()) instanceof PsiClass) {
                element.putCopyableUserData(REF_TO_CLASS, (Object)((PsiClass)resolvedElement));
                element.putCopyableUserData(KEY_ENCODED, KEY_ENCODED);
            }
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            GroovyChangeContextUtil.encodeContextInfo(child);
        }
    }

    public static void decodeContextInfo(PsiElement element, @Nullable PsiClass thisClass, @Nullable GrExpression thisAccessExpr) {
        if (!(element instanceof GroovyPsiElement)) {
            return;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            GroovyChangeContextUtil.decodeContextInfo(child, thisClass, thisAccessExpr);
        }
        if (element.getCopyableUserData(KEY_ENCODED) != null) {
            PsiReference ref;
            element.putCopyableUserData(KEY_ENCODED, null);
            PsiManager manager = element.getManager();
            if (element instanceof GrThisReferenceExpression) {
                PsiClass thisQualClass = (PsiClass)element.getCopyableUserData(QUALIFIER_CLASS_KEY);
                element.putCopyableUserData(QUALIFIER_CLASS_KEY, null);
                if (thisAccessExpr != null && !manager.areElementsEquivalent((PsiElement)thisClass, (PsiElement)thisQualClass)) {
                    element.replace((PsiElement)thisAccessExpr);
                    return;
                }
            } else if (element instanceof GrReferenceExpression) {
                PsiClass memberClass;
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
                GrReferenceExpression refExpr = (GrReferenceExpression)element;
                PsiElement resolvedElement = refExpr.resolve();
                PsiMember memberRef = (PsiMember)refExpr.getCopyableUserData(REF_TO_MEMBER);
                refExpr.putCopyableUserData(REF_TO_MEMBER, null);
                if (memberRef != null && memberRef.isValid() && (memberClass = memberRef.getContainingClass()) != null) {
                    PsiElement qualifier;
                    if (memberRef.hasModifierProperty("static")) {
                        PsiElement qualifier2;
                        if (!manager.areElementsEquivalent((PsiElement)memberRef, resolvedElement) && !((qualifier2 = refExpr.getQualifier()) instanceof GrReferenceExpression)) {
                            refExpr.setQualifierExpression(factory.createReferenceExpressionFromText(memberClass.getQualifiedName()));
                            return;
                        }
                    } else if (thisAccessExpr instanceof GrReferenceExpression && !((qualifier = refExpr.getQualifier()) instanceof GrReferenceExpression)) {
                        refExpr.setQualifierExpression((GrReferenceExpression)thisAccessExpr);
                        return;
                    }
                }
            }
            PsiClass refClass = (PsiClass)element.getCopyableUserData(REF_TO_CLASS);
            element.putCopyableUserData(REF_TO_CLASS, null);
            if (refClass != null && refClass.isValid() && (ref = element.getReference()) != null) {
                ref.bindToElement((PsiElement)refClass);
            }
        }
    }
}

