/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith.descriptors;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public abstract class GroovySurroundDescriptor
implements SurroundDescriptor {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] psiElementArray;
        GrStatement[] statements = this.findStatementsInRange(file, startOffset, endOffset);
        if (statements == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/surroundWith/descriptors/GroovySurroundDescriptor.getElementsToSurround must not return null");
            return psiElementArray;
        }
        psiElementArray = statements;
        if (statements != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/surroundWith/descriptors/GroovySurroundDescriptor.getElementsToSurround must not return null");
    }

    @Nullable
    private GrStatement[] findStatementsInRange(PsiFile file, int startOffset, int endOffset) {
        int endOffsetLocal = endOffset;
        int startOffsetLocal = startOffset;
        ArrayList<GrStatement> statements = new ArrayList<GrStatement>();
        while (true) {
            GrStatement statement;
            PsiElement element1 = file.findElementAt(startOffsetLocal);
            PsiElement element2 = file.findElementAt(endOffsetLocal - 1);
            if (element1 == null) break;
            ASTNode node1 = element1.getNode();
            assert (node1 != null);
            if (element1 instanceof PsiWhiteSpace || TokenSets.WHITE_SPACE_TOKEN_SET.contains(node1.getElementType()) || GroovyTokenTypes.mNLS.equals(node1.getElementType())) {
                startOffsetLocal = element1.getTextRange().getEndOffset();
            }
            if (element2 == null) break;
            ASTNode node2 = element2.getNode();
            assert (node2 != null);
            if (element2 instanceof PsiWhiteSpace || TokenSets.WHITE_SPACE_TOKEN_SET.contains(node2.getElementType()) || GroovyTokenTypes.mNLS.equals(node2.getElementType())) {
                endOffsetLocal = element2.getTextRange().getStartOffset();
            }
            if (";".equals(element2.getText())) {
                --endOffsetLocal;
            }
            if ((statement = (GrStatement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffsetLocal, (int)endOffsetLocal, GrStatement.class)) == null) break;
            statements.add(statement);
            startOffsetLocal = statement.getTextRange().getEndOffset();
            PsiElement endSemicolon = file.findElementAt(startOffsetLocal);
            if (endSemicolon == null || !";".equals(endSemicolon.getText())) continue;
            ++startOffsetLocal;
        }
        return statements.toArray(new GrStatement[0]);
    }
}

