/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class ResolverProcessor
implements PsiScopeProcessor,
NameHint,
ClassHint,
ElementClassHint {
    protected String myName;
    private final EnumSet<ClassHint.ResolveKind> myResolveTargetKinds;
    private final Set<String> myProcessedClasses;
    protected PsiElement myPlace;
    @NotNull
    private final PsiType[] myTypeArguments;
    protected Set<GroovyResolveResult> myCandidates;
    protected GroovyPsiElement myCurrentFileResolveContext;

    public GroovyPsiElement getCurrentFileResolveContext() {
        return this.myCurrentFileResolveContext;
    }

    public void setCurrentFileResolveContext(GroovyPsiElement currentFileResolveContext) {
        this.myCurrentFileResolveContext = currentFileResolveContext;
    }

    protected ResolverProcessor(String name, EnumSet<ClassHint.ResolveKind> resolveTargets, PsiElement place, @NotNull PsiType[] typeArguments) {
        if (typeArguments == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor.<init> must not be null");
        }
        this.myProcessedClasses = new HashSet<String>();
        this.myCandidates = new LinkedHashSet<GroovyResolveResult>();
        this.myName = name;
        this.myResolveTargetKinds = resolveTargets;
        this.myPlace = place;
        this.myTypeArguments = typeArguments;
    }

    public boolean execute(PsiElement element, ResolveState state) {
        if (this.myResolveTargetKinds.contains((Object)ResolverProcessor.getResolveKind(element))) {
            PsiNamedElement namedElement = (PsiNamedElement)element;
            PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            if (substitutor == null) {
                substitutor = PsiSubstitutor.EMPTY;
            }
            if (this.myTypeArguments.length > 0 && namedElement instanceof PsiClass) {
                substitutor = substitutor.putAll((PsiClass)namedElement, this.myTypeArguments);
            }
            if (namedElement instanceof PsiClass) {
                PsiClass aClass = (PsiClass)namedElement;
                String fqn = aClass.getQualifiedName();
                if (!this.myProcessedClasses.contains(fqn)) {
                    this.myProcessedClasses.add(fqn);
                } else {
                    return true;
                }
            }
            boolean isAccessible = this.isAccessible(namedElement);
            boolean isStaticsOK = this.isStaticsOK(namedElement);
            this.myCandidates.add(new GroovyResolveResultImpl((PsiElement)namedElement, this.myCurrentFileResolveContext, substitutor, isAccessible, isStaticsOK));
            return !isAccessible;
        }
        return true;
    }

    protected boolean isAccessible(PsiNamedElement namedElement) {
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(this.myPlace, (PsiMember)namedElement);
    }

    protected boolean isStaticsOK(PsiNamedElement element) {
        if (this.myCurrentFileResolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return PsiUtil.isStaticsOK((PsiModifierListOwner)element, this.myPlace);
        }
        return true;
    }

    @NotNull
    public GroovyResolveResult[] getCandidates() {
        GroovyResolveResult[] groovyResolveResultArray = this.myCandidates.toArray(new GroovyResolveResult[this.myCandidates.size()]);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor.getCandidates must not return null");
        }
        return groovyResolveResultArray;
    }

    public <T> T getHint(Key<T> hintKey) {
        if (NameHint.KEY == hintKey && this.myName != null) {
            return (T)this;
        }
        if (ClassHint.KEY == hintKey) {
            return (T)this;
        }
        if (ElementClassHint.KEY == hintKey) {
            return (T)this;
        }
        return null;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public boolean shouldProcess(ClassHint.ResolveKind resolveKind) {
        return this.myResolveTargetKinds.contains((Object)resolveKind);
    }

    public boolean shouldProcess(ElementClassHint.DeclaractionKind kind) {
        switch (kind) {
            case CLASS: {
                return this.shouldProcess(ClassHint.ResolveKind.CLASS);
            }
            case ENUM_CONST: 
            case VARIABLE: 
            case FIELD: {
                return this.shouldProcess(ClassHint.ResolveKind.PROPERTY);
            }
            case METHOD: {
                return this.shouldProcess(ClassHint.ResolveKind.METHOD);
            }
            case PACKAGE: {
                return this.shouldProcess(ClassHint.ResolveKind.PACKAGE);
            }
        }
        return false;
    }

    public boolean hasCandidates() {
        return this.myCandidates.size() > 0;
    }

    private static ClassHint.ResolveKind getResolveKind(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ClassHint.ResolveKind.PROPERTY;
        }
        if (element instanceof GrReferenceExpression) {
            return ClassHint.ResolveKind.PROPERTY;
        }
        if (element instanceof PsiMethod) {
            return ClassHint.ResolveKind.METHOD;
        }
        if (element instanceof PsiPackage) {
            return ClassHint.ResolveKind.PACKAGE;
        }
        return ClassHint.ResolveKind.CLASS;
    }

    public String getName(ResolveState state) {
        return this.myName;
    }
}

