/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicToolWindowWrapper;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DMethodElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrDynamicImplicitElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrDynamicImplicitMethod
extends LightElement
implements PsiMethod,
GrDynamicImplicitElement {
    private final PsiManager myManager;
    private final GrMethod myMethod;
    private final String myContainingClassName;
    private final Project myProject;

    public GrDynamicImplicitMethod(PsiManager manager, GrMethod method, String containingClassName) {
        super(manager, GroovyFileType.GROOVY_LANGUAGE);
        this.myManager = manager;
        this.myMethod = method;
        this.myProject = this.myManager.getProject();
        this.myContainingClassName = containingClassName;
    }

    public String[] getParameterTypes() {
        PsiParameter[] psiParameters = this.getParameterList().getParameters();
        ArrayList<String> result = new ArrayList<String>();
        for (PsiParameter psiParameter : psiParameters) {
            result.add(psiParameter.getTypeElement().getType().getCanonicalText());
        }
        return ArrayUtil.toStringArray(result);
    }

    @Override
    public String getContainingClassName() {
        return this.myContainingClassName;
    }

    @Override
    @Nullable
    public PsiClass getContainingClassElement() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myContainingClassName, ProjectScope.getAllScope((Project)this.getProject()));
    }

    public boolean hasTypeParameters() {
        return this.myMethod.hasTypeParameters();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = this.myMethod.getTypeParameters();
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myMethod.getTypeParameterList();
    }

    public PsiDocComment getDocComment() {
        return this.myMethod.getDocComment();
    }

    public boolean isDeprecated() {
        return this.myMethod.isDeprecated();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.setName must not be null");
        }
        return this.myMethod.setName(name);
    }

    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getName must not return null");
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = this.myMethod.getHierarchicalMethodSignature();
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    public boolean hasModifierProperty(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.hasModifierProperty must not be null");
        }
        final Ref res = new Ref();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                res.set((Object)GrDynamicImplicitMethod.this.myMethod.hasModifierProperty(name));
            }
        });
        return (Boolean)res.get();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        GrModifierList grModifierList = this.myMethod.getModifierList();
        if (grModifierList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getModifierList must not return null");
        }
        return grModifierList;
    }

    public PsiType getReturnType() {
        PsiType typeElement = this.myMethod.getDeclaredReturnType();
        if (typeElement == null) {
            return TypesUtil.getJavaLangObject(this.myMethod);
        }
        return typeElement;
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myMethod.getReturnTypeElement();
    }

    @NotNull
    public PsiParameterList getParameterList() {
        GrParameterList grParameterList = this.myMethod.getParameterList();
        if (grParameterList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getParameterList must not return null");
        }
        return grParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myMethod.getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    public PsiCodeBlock getBody() {
        return this.myMethod.getBody();
    }

    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    public boolean isVarArgs() {
        return this.myMethod.isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getSignature must not be null");
        }
        MethodSignature methodSignature = this.myMethod.getSignature(substitutor);
        if (methodSignature == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getSignature must not return null");
        }
        return methodSignature;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myMethod.getNameIdentifier();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List list = this.myMethod.findSuperMethodSignaturesIncludingStatic(checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return this.myMethod.findDeepestSuperMethod();
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findDeepestSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    public String getText() {
        return this.myMethod.getText();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.accept must not be null");
        }
        this.myMethod.accept(visitor);
    }

    public PsiElement copy() {
        return new GrDynamicImplicitMethod(this.myManager, (GrMethod)this.myMethod.copy(), this.myContainingClassName);
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass psiClass = this.getContainingClassElement();
        if (psiClass == null) {
            return null;
        }
        return psiClass.getContainingFile();
    }

    @Nullable
    public PsiClass getContainingClass() {
        final Ref aclass = new Ref(null);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    GrTypeElement typeElement = GroovyPsiElementFactory.getInstance(GrDynamicImplicitMethod.this.myProject).createTypeElement(GrDynamicImplicitMethod.this.myContainingClassName);
                    if (typeElement == null) {
                        return;
                    }
                    PsiType type = typeElement.getType();
                    if (!(type instanceof PsiClassType)) {
                        return;
                    }
                    aclass.set((Object)((PsiClassType)type).resolve());
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        });
        return (PsiClass)aclass.get();
    }

    public String toString() {
        return "DynamicMethod:" + this.getName();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrDynamicImplicitMethod.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    public void navigate(boolean requestFocus) {
        DynamicToolWindowWrapper.getInstance(this.myProject).getToolWindow().activate(new Runnable(){

            @Override
            public void run() {
                DynamicToolWindowWrapper toolWindowWrapper = DynamicToolWindowWrapper.getInstance(GrDynamicImplicitMethod.this.myProject);
                TreeTable treeTable = toolWindowWrapper.getTreeTable();
                ListTreeTableModelOnColumns model = toolWindowWrapper.getTreeTableModel();
                Object root = model.getRoot();
                if (root == null || !(root instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)root;
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)GrDynamicImplicitMethod.this.getProject());
                PsiClassType fqClassName = facade.getElementFactory().createTypeByFQClassName(GrDynamicImplicitMethod.this.myContainingClassName, ProjectScope.getAllScope((Project)GrDynamicImplicitMethod.this.getProject()));
                PsiClass psiClass = fqClassName.resolve();
                if (psiClass == null) {
                    return;
                }
                PsiClass trueClass = null;
                DMethodElement methodElement = null;
                GrParameter[] parameters = GrDynamicImplicitMethod.this.myMethod.getParameterList().getParameters();
                ArrayList<String> parameterTypes = new ArrayList<String>();
                for (GrParameter parameter : parameters) {
                    String type = parameter.getTypeElementGroovy().getType().getCanonicalText();
                    parameterTypes.add(type);
                }
                for (PsiClass aSuper : PsiUtil.iterateSupers(psiClass, true)) {
                    methodElement = DynamicManager.getInstance(GrDynamicImplicitMethod.this.myProject).findConcreteDynamicMethod(aSuper.getQualifiedName(), GrDynamicImplicitMethod.this.getName(), ArrayUtil.toStringArray(parameterTypes));
                    if (methodElement == null) continue;
                    trueClass = aSuper;
                    break;
                }
                if (trueClass == null) {
                    return;
                }
                DefaultMutableTreeNode classNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)treeRoot, (Object)new DClassElement(GrDynamicImplicitMethod.this.myProject, trueClass.getQualifiedName()));
                if (classNode == null) {
                    return;
                }
                DefaultMutableTreeNode desiredNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)classNode, (Object)methodElement);
                if (desiredNode == null) {
                    return;
                }
                TreePath path = TreeUtil.getPathFromRoot((TreeNode)desiredNode);
                treeTable.getTree().expandPath(path);
                treeTable.getTree().setSelectionPath(path);
                treeTable.getTree().fireTreeExpanded(path);
                treeTable.revalidate();
                treeTable.repaint();
            }
        }, true);
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public String getPresentableText() {
        return this.getName();
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return GroovyIcons.METHOD;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return null;
    }

    public GrMethod getMethod() {
        return this.myMethod;
    }

    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }

    public PsiElement getContext() {
        return this.myMethod;
    }
}

