/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralEscaper;

public class GrLiteralImpl
extends GrExpressionImpl
implements GrLiteral,
PsiLanguageInjectionHost {
    public GrLiteralImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "Literal";
    }

    @Override
    public PsiType getType() {
        IElementType elemType = this.getFirstChild().getNode().getElementType();
        return TypesUtil.getPsiType(this, elemType);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitLiteralExpression(this);
    }

    public Object getValue() {
        PsiElement child = this.getFirstChild();
        IElementType elemType = child.getNode().getElementType();
        String text = child.getText();
        if (elemType == GroovyTokenTypes.mNUM_INT) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
            }
        } else if (elemType == GroovyTokenTypes.mNUM_LONG) {
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
            }
        } else if (elemType == GroovyTokenTypes.mNUM_FLOAT) {
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (NumberFormatException e) {
            }
        } else if (elemType == GroovyTokenTypes.mNUM_DOUBLE) {
            try {
                return Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
            }
        } else if (elemType == GroovyTokenTypes.mNUM_BIG_INT) {
            try {
                return new BigInteger(text);
            }
            catch (NumberFormatException e) {
            }
        } else if (elemType == GroovyTokenTypes.mNUM_BIG_DECIMAL) {
            try {
                return new BigDecimal(text);
            }
            catch (NumberFormatException e) {
            }
        } else {
            if (elemType == GroovyTokenTypes.kFALSE) {
                return Boolean.FALSE;
            }
            if (elemType == GroovyTokenTypes.kTRUE) {
                return Boolean.TRUE;
            }
            if (elemType == GroovyTokenTypes.mSTRING_LITERAL) {
                if (!text.startsWith("'")) {
                    return null;
                }
                if ((text = text.substring(1)).endsWith("'")) {
                    text = text.substring(0, text.length() - 1);
                }
                return StringUtil.unescapeStringCharacters((String)text);
            }
            if (elemType == GroovyTokenTypes.mGSTRING_LITERAL) {
                if (!text.startsWith("\"")) {
                    return null;
                }
                text = text.startsWith("\"\"\"") ? StringUtil.trimEnd((String)text.substring(3), (String)"\"\"\"") : StringUtil.trimEnd((String)text.substring(1), (String)"\"");
                return StringUtil.unescapeStringCharacters((String)text);
            }
        }
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, GrLiteral.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length > 0) {
            return new PsiMultiReference(references, (PsiElement)this);
        }
        return null;
    }

    public List<Pair<PsiElement, TextRange>> getInjectedPsi() {
        if (!(this.getValue() instanceof String)) {
            return null;
        }
        return InjectedLanguageUtil.getInjectedPsiFiles((PsiElement)this);
    }

    public void processInjectedPsi(@NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl.processInjectedPsi must not be null");
        }
        InjectedLanguageUtil.enumerate((PsiElement)this, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor);
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl.updateText must not be null");
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<GrLiteralImpl> createLiteralTextEscaper() {
        GrLiteralEscaper grLiteralEscaper = new GrLiteralEscaper(this);
        if (grLiteralEscaper == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl.createLiteralTextEscaper must not return null");
        }
        return grLiteralEscaper;
    }
}

