/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrApplicationStatementImpl
extends GrExpressionImpl
implements GrApplicationStatement {
    public GrApplicationStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrApplicationStatementImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitApplicationStatement(this);
    }

    public String toString() {
        return "Call expression";
    }

    @Override
    public GrExpression getFunExpression() {
        return (GrExpression)this.findChildByClass(GrExpression.class);
    }

    @Override
    public GrExpression[] getArguments() {
        GrCommandArgumentList list = this.getArgumentList();
        if (list == null) {
            return GrExpression.EMPTY_ARRAY;
        }
        return list.getExpressionArguments();
    }

    @Override
    public GrCommandArgumentList getArgumentList() {
        return (GrCommandArgumentList)this.findChildByClass(GrCommandArgumentList.class);
    }

    @Override
    public GrExpression removeArgument(int number) {
        GrCommandArgumentList list = this.getArgumentList();
        return list != null ? list.removeArgument(number) : null;
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrCommandArgumentList list = this.getArgumentList();
        assert (list != null);
        return list.addNamedArgument(namedArgument);
    }

    @Override
    public PsiType getType() {
        PsiType type;
        GrExpression invoked = this.getFunExpression();
        if (invoked instanceof GrReferenceExpression && (type = invoked.getType()) != null) {
            return TypesUtil.boxPrimitiveType(type, (PsiManager)this.getManager(), this.getResolveScope());
        }
        return null;
    }
}

