/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrApplicationStatementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class CompleteReferenceExpression {
    private CompleteReferenceExpression() {
    }

    public static void processVariants(Consumer<Object> consumer, GrReferenceExpressionImpl refExpr) {
        PsiElement refParent = refExpr.getParent();
        CompleteReferenceExpression.processArgsVariants(consumer, refParent);
        GrExpression qualifier = refExpr.getQualifierExpression();
        Object[] propertyVariants = CompleteReferenceExpression.getVariantsImpl(refExpr, CompletionProcessor.createPropertyCompletionProcessor(refExpr));
        PsiType type = null;
        if (qualifier == null) {
            PsiElement argList;
            if (refParent instanceof GrArgumentList && (argList = refParent.getParent()) instanceof GrExpression) {
                GrExpression call = (GrExpression)argList;
                type = call.getType();
            }
        } else {
            type = qualifier.getType();
        }
        if (type instanceof PsiClassType) {
            PsiClass clazz = ((PsiClassType)type).resolve();
            if (clazz != null) {
                Set<String> accessedPropertyNames = CompleteReferenceExpression.processPropertyVariants(consumer, refExpr, clazz);
                for (Object variant : propertyVariants) {
                    if (variant instanceof PsiField && accessedPropertyNames.contains(((PsiField)variant).getName())) continue;
                    consumer.consume(variant);
                }
            }
        } else {
            for (Object variant : propertyVariants) {
                consumer.consume(variant);
            }
        }
        if (refExpr.getKind() == GrReferenceExpressionImpl.Kind.TYPE_OR_PROPERTY) {
            Object[] classVariants;
            ResolverProcessor classVariantsCollector = CompletionProcessor.createClassCompletionProcessor(refExpr);
            for (Object variant : classVariants = CompleteReferenceExpression.getVariantsImpl(refExpr, classVariantsCollector)) {
                consumer.consume(variant);
            }
        }
    }

    private static void processArgsVariants(Consumer<Object> consumer, PsiElement refParent) {
        PsiElement refPParent;
        if (refParent instanceof GrArgumentList && (refPParent = refParent.getParent()) instanceof GrCall) {
            GrExpression element;
            GrCall constructorCall;
            Object[] results = new GroovyResolveResult[]{};
            if (refPParent instanceof GrConstructorCall) {
                constructorCall = (GrConstructorCall)refPParent;
                results = (GroovyResolveResult[])ArrayUtil.mergeArrays((Object[])results, (Object[])constructorCall.multiResolveConstructor(), GroovyResolveResult.class);
            } else if (refPParent instanceof GrCallExpression) {
                constructorCall = (GrCallExpression)refPParent;
                results = (GroovyResolveResult[])ArrayUtil.mergeArrays((Object[])results, (Object[])constructorCall.getMethodVariants(), GroovyResolveResult.class);
            } else if (refPParent instanceof GrApplicationStatementImpl && (element = ((GrApplicationStatementImpl)refPParent).getFunExpression()) instanceof GrReferenceElement) {
                results = (GroovyResolveResult[])ArrayUtil.mergeArrays((Object[])results, (Object[])((GrReferenceElement)((Object)element)).multiResolve(true), GroovyResolveResult.class);
            }
            for (Object result : results) {
                Set<String>[] parametersArray;
                PsiElement element2 = result.getElement();
                if (!(element2 instanceof GrMethod)) continue;
                for (Set<String> namedParameters : parametersArray = ((GrMethod)element2).getNamedParametersArray()) {
                    for (String parameter : namedParameters) {
                        consumer.consume((Object)parameter);
                    }
                }
            }
        }
    }

    private static Set<String> processPropertyVariants(Consumer<Object> consumer, GrReferenceExpression refExpr, PsiClass clazz) {
        THashSet accessedPropertyNames = new THashSet();
        PsiClass eventListener = JavaPsiFacade.getInstance((Project)refExpr.getProject()).findClass("java.util.EventListener", refExpr.getResolveScope());
        for (PsiMethod method : clazz.getAllMethods()) {
            if (!PsiUtil.isStaticsOK((PsiModifierListOwner)method, refExpr)) continue;
            if (GroovyPropertyUtils.isSimplePropertyAccessor(method)) {
                String prop = GroovyPropertyUtils.getPropertyName(method);
                accessedPropertyNames.add(prop);
                assert (prop != null);
                consumer.consume((Object)LookupElementBuilder.create((String)prop).setIcon(GroovyIcons.PROPERTY));
                continue;
            }
            if (eventListener == null) continue;
            CompleteReferenceExpression.consumeListenerProperties(consumer, method, eventListener);
        }
        return accessedPropertyNames;
    }

    private static void consumeListenerProperties(Consumer<Object> consumer, PsiMethod method, PsiClass eventListenerClass) {
        PsiClassType classType;
        PsiClass listenerClass;
        PsiParameter parameter;
        PsiType type;
        if (method.getName().startsWith("add") && method.getParameterList().getParametersCount() == 1 && (type = (parameter = method.getParameterList().getParameters()[0]).getType()) instanceof PsiClassType && (listenerClass = (classType = (PsiClassType)type).resolve()) != null) {
            PsiMethod[] listenerMethods = listenerClass.getMethods();
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)listenerClass, (PsiClass)eventListenerClass, (boolean)true)) {
                for (PsiMethod listenerMethod : listenerMethods) {
                    consumer.consume((Object)LookupElementBuilder.create((String)listenerMethod.getName()).setIcon(GroovyIcons.PROPERTY));
                }
            }
        }
    }

    private static Object[] getVariantsImpl(GrReferenceExpression refExpr, ResolverProcessor processor) {
        Object[] candidates;
        GrExpression qualifier = refExpr.getQualifierExpression();
        Object[] sameQualifier = CompleteReferenceExpression.getVariantsWithSameQualifier(qualifier, refExpr);
        if (qualifier == null) {
            ResolveUtil.treeWalkUp(refExpr, processor, true);
            qualifier = PsiImplUtil.getRuntimeQualifier(refExpr);
            if (qualifier != null) {
                CompleteReferenceExpression.getVariantsFromQualifier(refExpr, processor, qualifier);
            }
        } else if (refExpr.getDotTokenType() != GroovyTokenTypes.mSPREAD_DOT) {
            CompleteReferenceExpression.getVariantsFromQualifier(refExpr, processor, qualifier);
        } else {
            CompleteReferenceExpression.getVariantsFromQualifierForSpreadOperator(refExpr, processor, qualifier);
        }
        if ((candidates = processor.getCandidates()).length == 0 && sameQualifier.length == 0) {
            return PsiNamedElement.EMPTY_ARRAY;
        }
        candidates = CompleteReferenceExpression.filterStaticsOK((GroovyResolveResult[])candidates);
        PsiElement[] elements = ResolveUtil.mapToElements((GroovyResolveResult[])candidates);
        if (qualifier == null) {
            List nonPackages = ContainerUtil.findAll((Object[])candidates, (Condition)new Condition<GroovyResolveResult>(){

                public boolean value(GroovyResolveResult result) {
                    return !(result.getElement() instanceof PsiPackage);
                }
            });
            candidates = nonPackages.toArray(new GroovyResolveResult[nonPackages.size()]);
        }
        Object[] propertyLookupElements = CompleteReferenceExpression.addPretendedProperties(elements);
        Object[] variants = GroovyCompletionUtil.getCompletionVariants((GroovyResolveResult[])candidates);
        variants = ArrayUtil.mergeArrays((Object[])variants, (Object[])propertyLookupElements, Object.class);
        return ArrayUtil.mergeArrays((Object[])variants, (Object[])sameQualifier, Object.class);
    }

    private static GroovyResolveResult[] filterStaticsOK(GroovyResolveResult[] candidates) {
        ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>(candidates.length);
        for (GroovyResolveResult resolveResult : candidates) {
            if (!resolveResult.isStaticsOK()) continue;
            result.add(resolveResult);
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    private static void getVariantsFromQualifierForSpreadOperator(GrReferenceExpression refExpr, ResolverProcessor processor, GrExpression qualifier) {
        PsiType qualifierType = qualifier.getType();
        if (qualifierType instanceof PsiClassType) {
            PsiType componentType;
            PsiSubstitutor substitutor;
            PsiClass listClass;
            PsiClassType.ClassResolveResult result = ((PsiClassType)qualifierType).resolveGenerics();
            PsiClass clazz = result.getElement();
            if (clazz != null && (listClass = JavaPsiFacade.getInstance((Project)refExpr.getProject()).findClass("java.util.List", refExpr.getResolveScope())) != null && listClass.getTypeParameters().length == 1 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)listClass, (PsiClass)clazz, (PsiSubstitutor)result.getSubstitutor())) != null && (componentType = substitutor.substitute(listClass.getTypeParameters()[0])) != null) {
                CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, componentType, refExpr.getProject());
            }
        } else if (qualifierType instanceof PsiArrayType) {
            CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, ((PsiArrayType)qualifierType).getComponentType(), refExpr.getProject());
        }
    }

    private static LookupElement[] addPretendedProperties(PsiElement[] elements) {
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (PsiElement element : elements) {
            PsiMethod method;
            if (!(element instanceof PsiMethod) || element instanceof GrAccessorMethod || !GroovyPropertyUtils.isSimplePropertyAccessor(method = (PsiMethod)element)) continue;
            String propName = GroovyPropertyUtils.getPropertyName(method);
            if (!PsiUtil.isValidReferenceName(propName)) {
                propName = "'" + propName + "'";
            }
            assert (propName != null);
            result.add(LookupElementBuilder.create((String)propName).setIcon(GroovyIcons.PROPERTY));
        }
        return result.toArray(new LookupElement[result.size()]);
    }

    private static void getVariantsFromQualifier(GrReferenceExpression refExpr, ResolverProcessor processor, GrExpression qualifier) {
        Project project = qualifier.getProject();
        PsiType qualifierType = qualifier.getType();
        if (qualifierType == null) {
            PsiElement resolved;
            if (qualifier instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiPackage) {
                resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)refExpr);
                return;
            }
            PsiClassType type = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.GroovyObject", refExpr.getResolveScope());
            CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, (PsiType)type, project);
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, conjunct, project);
            }
        } else {
            GlobalSearchScope scope;
            PsiClass javaLangClass;
            PsiElement resolved;
            CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, qualifierType, project);
            if (qualifier instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && (javaLangClass = PsiUtil.getJavaLangClass(resolved, scope = refExpr.getResolveScope())) != null) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                if (typeParameters.length == 1) {
                    substitutor = substitutor.put(typeParameters[0], qualifierType);
                }
                javaLangClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)refExpr);
                PsiClassType javaLangClassType = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory().createType(javaLangClass, substitutor);
                ResolveUtil.processNonCodeMethods((PsiType)javaLangClassType, processor, refExpr.getProject(), refExpr, true);
            }
        }
    }

    private static String[] getVariantsWithSameQualifier(GrExpression qualifier, GrReferenceExpression refExpr) {
        if (qualifier != null && qualifier.getType() != null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)refExpr, (Class[])new Class[]{GrMember.class, GroovyFileBase.class});
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        CompleteReferenceExpression.addVariantsWithSameQualifier(scope, refExpr, qualifier, result);
        return ArrayUtil.toStringArray(result);
    }

    private static void addVariantsWithSameQualifier(PsiElement element, GrReferenceExpression patternExpression, GrExpression patternQualifier, Set<String> result) {
        GrReferenceExpression refExpr;
        String refName;
        if (element instanceof GrReferenceExpression && element != patternExpression && !PsiUtil.isLValue((GroovyPsiElement)element) && (refName = (refExpr = (GrReferenceExpression)element).getReferenceName()) != null && !result.contains(refName)) {
            GrExpression hisQualifier = refExpr.getQualifierExpression();
            if (hisQualifier != null && patternQualifier != null) {
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)hisQualifier, (PsiElement)patternQualifier) && refExpr.resolve() == null) {
                    result.add(refName);
                }
            } else if (hisQualifier == null && patternQualifier == null && refExpr.resolve() == null) {
                result.add(refName);
            }
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            CompleteReferenceExpression.addVariantsWithSameQualifier(child, patternExpression, patternQualifier, result);
        }
    }

    private static void getVariantsFromQualifierType(GrReferenceExpression refExpr, ResolverProcessor processor, PsiType qualifierType, Project project) {
        if (qualifierType instanceof PsiClassType) {
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (qualifierClass != null) {
                qualifierClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)refExpr);
            }
            if (!ResolveUtil.processCategoryMembers(refExpr, processor)) {
                return;
            }
        } else if (qualifierType instanceof PsiArrayType) {
            GrTypeDefinition arrayClass = GroovyPsiManager.getInstance(project).getArrayClass();
            if (!arrayClass.processDeclarations(processor, ResolveState.initial(), null, refExpr)) {
                return;
            }
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                CompleteReferenceExpression.getVariantsFromQualifierType(refExpr, processor, conjunct, project);
            }
            return;
        }
        ResolveUtil.processNonCodeMethods(qualifierType, processor, project, refExpr, true);
    }
}

