/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrForStatementImpl
extends GroovyPsiElementImpl
implements GrForStatement {
    public GrForStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrForStatementImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitForStatement(this);
    }

    public String toString() {
        return "For statement";
    }

    @Override
    public GrForClause getClause() {
        return (GrForClause)this.findChildByClass(GrForClause.class);
    }

    @Override
    public GrStatement getBody() {
        return (GrStatement)this.findChildByClass(GrStatement.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrForStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrForStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrForStatementImpl.processDeclarations must not be null");
        }
        GrForClause forClause = this.getClause();
        GrVariable varScope = (GrVariable)PsiTreeUtil.getParentOfType((PsiElement)place, GrVariable.class);
        if (forClause != null && lastParent != null && !(lastParent instanceof GrForInClause)) {
            GrVariable[] vars;
            for (GrVariable var : vars = forClause.getDeclaredVariables()) {
                if (var.equals(varScope)) break;
                if (ResolveUtil.processElement(processor, var)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GrCondition replaceBody(GrCondition newBody) throws IncorrectOperationException {
        if (this.getBody() == null || newBody == null) {
            throw new IncorrectOperationException();
        }
        ASTNode oldBodyNode = this.getBody().getNode();
        if (oldBodyNode.getTreePrev() != null && GroovyTokenTypes.mNLS.equals(oldBodyNode.getTreePrev().getElementType())) {
            ASTNode whiteNode = GroovyPsiElementFactory.getInstance(this.getProject()).createWhiteSpace().getNode();
            this.getNode().replaceChild(oldBodyNode.getTreePrev(), whiteNode);
        }
        this.getNode().replaceChild(oldBodyNode, newBody.getNode());
        ASTNode newNode = newBody.getNode();
        if (!(newNode.getPsi() instanceof GrCondition)) {
            throw new IncorrectOperationException();
        }
        return (GrCondition)newNode.getPsi();
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLParenth() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN);
    }
}

