/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyBaseElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrModifierListStub;

public class GrModifierListImpl
extends GroovyBaseElementImpl<GrModifierListStub>
implements GrModifierList {
    public static final TObjectIntHashMap<String> NAME_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();

    public GrModifierListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.<init> must not be null");
        }
        super(node);
    }

    public GrModifierListImpl(GrModifierListStub stub) {
        this(stub, (IStubElementType)GroovyElementTypes.MODIFIERS);
    }

    public GrModifierListImpl(GrModifierListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitModifierList(this);
    }

    public String toString() {
        return "Modifiers";
    }

    @Override
    @NotNull
    public PsiElement[] getModifiers() {
        ArrayList<PsiElement> modifiers = new ArrayList<PsiElement>();
        PsiElement[] modifiersKeywords = this.findChildrenByType(TokenSets.MODIFIERS, PsiElement.class);
        GrAnnotation[] modifiersAnnotations = (GrAnnotation[])this.findChildrenByClass(GrAnnotation.class);
        PsiElement defKeyword = this.findChildByType(GroovyTokenTypes.kDEF);
        if (modifiersKeywords.length != 0) {
            modifiers.addAll(Arrays.asList(modifiersKeywords));
        }
        if (modifiersAnnotations.length != 0) {
            modifiers.addAll(Arrays.asList(modifiersAnnotations));
        }
        if (defKeyword != null) {
            modifiers.add(defKeyword);
        }
        PsiElement[] psiElementArray = modifiers.toArray(new PsiElement[modifiers.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.getModifiers must not return null");
        }
        return psiElementArray;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        GrModifierListStub stub = (GrModifierListStub)this.getStub();
        if (stub != null) {
            return (stub.getModifiersFlags() & 7) != 0;
        }
        return this.findChildByType(TokenSets.VISIBILITY_MODIFIERS) != null;
    }

    public boolean hasModifierProperty(@NotNull @NonNls String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.hasModifierProperty must not be null");
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration && parent.getParent() instanceof GrTypeDefinitionBody) {
            GrModifierList modifierList;
            PsiElement pParent = parent.getParent().getParent();
            if (!this.hasExplicitVisibilityModifiers()) {
                if (!(pParent instanceof PsiClass) || !((PsiClass)pParent).isInterface()) {
                    if (modifier.equals("private")) {
                        return true;
                    }
                    if (modifier.equals("protected")) {
                        return false;
                    }
                    if (modifier.equals("public")) {
                        return false;
                    }
                } else {
                    if (modifier.equals("static")) {
                        return true;
                    }
                    if (modifier.equals("final")) {
                        return true;
                    }
                }
            }
            if (pParent instanceof GrTypeDefinition && (modifierList = ((GrTypeDefinition)pParent).getModifierList()) != null && modifierList.findAnnotation("groovy.lang.Immutable") != null && modifier.equals("final")) {
                return true;
            }
        }
        if (this.hasExplicitModifier(modifier)) {
            return true;
        }
        if (modifier.equals("public")) {
            return !this.hasExplicitModifier("private") && !this.hasExplicitModifier("protected");
        }
        if (parent instanceof GrTypeDefinition && modifier.equals("abstract")) {
            return ((GrTypeDefinition)parent).isInterface();
        }
        return false;
    }

    public boolean hasExplicitModifier(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.hasExplicitModifier must not be null");
        }
        GrModifierListStub stub = (GrModifierListStub)this.getStub();
        if (stub != null) {
            int flag = NAME_TO_MODIFIER_FLAG_MAP.get((Object)name);
            return (stub.getModifiersFlags() & flag) != 0;
        }
        if (name.equals("public")) {
            return this.findChildByType(GroovyElementTypes.kPUBLIC) != null;
        }
        if (name.equals("abstract")) {
            return this.findChildByType(GroovyElementTypes.kABSTRACT) != null;
        }
        if (name.equals("native")) {
            return this.findChildByType(GroovyElementTypes.kNATIVE) != null;
        }
        if (name.equals("private")) {
            return this.findChildByType(GroovyElementTypes.kPRIVATE) != null;
        }
        if (name.equals("protected")) {
            return this.findChildByType(GroovyElementTypes.kPROTECTED) != null;
        }
        if (name.equals("synchronized")) {
            return this.findChildByType(GroovyElementTypes.kSYNCHRONIZED) != null;
        }
        if (name.equals("strictfp")) {
            return this.findChildByType(GroovyElementTypes.kSTRICTFP) != null;
        }
        if (name.equals("static")) {
            return this.findChildByType(GroovyElementTypes.kSTATIC) != null;
        }
        if (name.equals("final")) {
            return this.findChildByType(GroovyElementTypes.kFINAL) != null;
        }
        if (name.equals("transient")) {
            return this.findChildByType(GroovyElementTypes.kTRANSIENT) != null;
        }
        if (name.equals("native")) {
            return this.findChildByType(GroovyElementTypes.kNATIVE) != null;
        }
        return name.equals("volatile") && this.findChildByType(GroovyElementTypes.kVOLATILE) != null;
    }

    public void setModifierProperty(@NotNull @NonNls String name, boolean doSet) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.setModifierProperty must not be null");
        }
        if (this.hasModifierProperty(name) == doSet) {
            return;
        }
        if (doSet && ("private".equals(name) || "protected".equals(name) || "public".equals(name) || "packageLocal".equals(name))) {
            this.setModifierPropertyInternal("public", false);
            this.setModifierPropertyInternal("protected", false);
            this.setModifierPropertyInternal("private", false);
        }
        if ("packageLocal".equals(name)) {
            if (this.getModifiers().length == 0) {
                this.setModifierProperty("def", true);
            }
        } else {
            this.setModifierPropertyInternal(name, doSet);
        }
    }

    private void setModifierPropertyInternal(String name, boolean doSet) {
        if (doSet) {
            ASTNode modifierNode = GroovyPsiElementFactory.getInstance(this.getProject()).createModifierFromText(name).getNode();
            this.addInternal(modifierNode, modifierNode, null, null);
        } else {
            PsiElement[] modifiers;
            for (PsiElement modifier : modifiers = this.findChildrenByType(TokenSets.MODIFIERS, PsiElement.class)) {
                if (!name.equals(modifier.getText())) continue;
                this.deleteChildRange(modifier, modifier);
                break;
            }
        }
    }

    public void checkSetModifierProperty(@NotNull @NonNls String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.checkSetModifierProperty must not be null");
        }
    }

    @Override
    @NotNull
    public GrAnnotation[] getAnnotations() {
        GrAnnotation[] grAnnotationArray = (GrAnnotation[])this.findChildrenByClass(GrAnnotation.class);
        if (grAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.getAnnotations must not return null");
        }
        return grAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        GrAnnotation[] annotations;
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.findAnnotation must not be null");
        }
        for (GrAnnotation annotation : annotations = this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GrAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        GrAnnotation grAnnotation;
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.addAnnotation must not be null");
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qualifiedName, this.getResolveScope());
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        if (psiClass != null && psiClass.isAnnotationType()) {
            GrAnnotation annotation = (GrAnnotation)this.addAfter(factory.createModifierFromText("@xxx"), null);
            annotation.getClassReference().bindToElement((PsiElement)psiClass);
            grAnnotation = annotation;
            if (grAnnotation == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.addAnnotation must not return null");
            return grAnnotation;
        }
        grAnnotation = (GrAnnotation)this.addAfter(factory.createModifierFromText("@" + qualifiedName), null);
        if (grAnnotation != null) return grAnnotation;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl.addAnnotation must not return null");
    }

    static {
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"volatile", 64);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"def", 131072);
    }
}

