/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GroovyFileBaseImpl
extends PsiFileBase
implements GroovyFileBase,
GrControlFlowOwner {
    private Instruction[] myControlFlow;

    protected GroovyFileBaseImpl(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl.<init> must not be null");
        }
        super(viewProvider, language);
        this.myControlFlow = null;
    }

    public GroovyFileBaseImpl(IFileElementType root, IFileElementType root1, FileViewProvider provider) {
        this(provider, root.getLanguage());
        this.init((IElementType)root, (IElementType)root1);
    }

    @NotNull
    public FileType getFileType() {
        GroovyFileType groovyFileType = GroovyFileType.GROOVY_FILE_TYPE;
        if (groovyFileType == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl.getFileType must not return null");
        }
        return groovyFileType;
    }

    public String toString() {
        return "Groovy script";
    }

    @Override
    public GrTypeDefinition[] getTypeDefinitions() {
        return (GrTypeDefinition[])this.findChildrenByClass(GrTypeDefinition.class);
    }

    @Override
    public GrTopLevelDefintion[] getTopLevelDefinitions() {
        return (GrTopLevelDefintion[])this.findChildrenByClass(GrTopLevelDefintion.class);
    }

    @Override
    public GrMethod[] getTopLevelMethods() {
        return (GrMethod[])this.findChildrenByClass(GrMethod.class);
    }

    @Override
    public GrVariableDeclaration[] getTopLevelVariableDeclarations() {
        return (GrVariableDeclaration[])this.findChildrenByClass(GrVariableDeclaration.class);
    }

    @Override
    public GrTopStatement[] getTopStatements() {
        return (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class);
    }

    public boolean importClass(PsiClass aClass) {
        return this.addImportForClass(aClass) != null;
    }

    @Override
    public void removeImport(GrImportStatement importStatement) throws IncorrectOperationException {
        PsiElement last;
        PsiElement before = importStatement.getPrevSibling();
        while (before instanceof PsiWhiteSpace || GroovyFileBaseImpl.hasElementType(before, GroovyTokenTypes.mNLS)) {
            before = before.getPrevSibling();
        }
        GrImportStatement rangeStart = importStatement;
        if (before != null && !(before instanceof PsiImportStatement) && before != importStatement.getPrevSibling()) {
            rangeStart = before.getNextSibling();
            PsiElement el = this.addBefore(GroovyPsiElementFactory.getInstance(this.getProject()).createLineTerminator(2), rangeStart);
            rangeStart = el.getNextSibling();
        }
        PsiElement rangeEnd = importStatement.getNextSibling();
        while (rangeEnd instanceof PsiWhiteSpace || GroovyFileBaseImpl.hasElementType(rangeEnd, GroovyTokenTypes.mSEMI)) {
            rangeEnd = rangeEnd.getNextSibling();
        }
        PsiElement psiElement = last = GroovyFileBaseImpl.hasElementType(rangeEnd, GroovyTokenTypes.mNLS) ? rangeEnd : rangeEnd.getPrevSibling();
        if (rangeStart != null && last != null) {
            this.deleteChildRange(rangeStart, last);
        }
    }

    private static boolean hasElementType(PsiElement next, IElementType type) {
        if (next == null) {
            return false;
        }
        ASTNode astNode = next.getNode();
        return astNode != null && astNode.getElementType() == type;
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            if (element.getParent() != this) {
                throw new IncorrectOperationException();
            }
            this.deleteChildRange(element, element);
        }
    }

    @Override
    public GrStatement addStatementBefore(@NotNull GrStatement statement, @Nullable GrStatement anchor) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl.addStatementBefore must not be null");
        }
        PsiElement result = this.addBefore(statement, anchor);
        if (anchor != null) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor.getNode());
        }
        return (GrStatement)result;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitFile(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor);
        }
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getTypeDefinitions();
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileBaseImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myControlFlow = null;
    }

    @Override
    public Instruction[] getControlFlow() {
        if (this.myControlFlow == null) {
            this.myControlFlow = new ControlFlowBuilder(this.getProject()).buildControlFlow(this, null, null);
        }
        return this.myControlFlow;
    }
}

