/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureSignatureUtil;

public class GrClosureType
extends PsiClassType {
    private final GlobalSearchScope myScope;
    private final PsiManager myManager;
    @NotNull
    private final GrClosureSignature mySignature;

    private GrClosureType(LanguageLevel languageLevel, GlobalSearchScope scope, PsiManager manager, @NotNull GrClosureSignature closureSignature) {
        if (closureSignature == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.<init> must not be null");
        }
        super(languageLevel);
        this.myScope = scope;
        this.myManager = manager;
        this.mySignature = closureSignature;
    }

    @Nullable
    public PsiClass resolve() {
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass("groovy.lang.Closure", this.getResolveScope());
    }

    public String getClassName() {
        return "Closure";
    }

    @NotNull
    public PsiType[] getParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.getParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                return GrClosureType.this.resolve();
            }

            public PsiSubstitutor getSubstitutor() {
                return PsiSubstitutor.UNKNOWN;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return true;
            }

            public boolean isStaticsScopeCorrect() {
                return true;
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
        if (classResolveResult == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.resolveGenerics must not return null");
        }
        return classResolveResult;
    }

    @NotNull
    public PsiClassType rawType() {
        GrClosureType grClosureType = this;
        if (grClosureType == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.rawType must not return null");
        }
        return grClosureType;
    }

    @NotNull
    public String getPresentableText() {
        if ("Closure" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.getPresentableText must not return null");
        }
        return "Closure";
    }

    @Nullable
    public String getCanonicalText() {
        PsiClass resolved = this.resolve();
        if (resolved == null) {
            return null;
        }
        return resolved.getQualifiedName();
    }

    @Nullable
    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    public boolean isValid() {
        return this.mySignature.isValid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureType) {
            return Comparing.equal((Object)this.mySignature, (Object)((GrClosureType)((Object)obj)).mySignature);
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.isAssignableFrom must not be null");
        }
        if (type instanceof GrClosureType) {
            GrClosureParameter[] otherParameters;
            GrClosureType other = (GrClosureType)type;
            GrClosureSignature otherSignature = other.mySignature;
            PsiType myReturnType = this.mySignature.getReturnType();
            PsiType otherReturnType = otherSignature.getReturnType();
            if (myReturnType == null || otherReturnType == null) {
                return myReturnType == null && otherReturnType == null;
            }
            if (!myReturnType.isAssignableFrom(otherReturnType)) {
                return false;
            }
            GrClosureParameter[] myParameters = this.mySignature.getParameters();
            if (myParameters.length != (otherParameters = otherSignature.getParameters()).length) {
                return false;
            }
            for (int i = 0; i < myParameters.length; ++i) {
                if (myParameters[i].isOptional() != otherParameters[i].isOptional()) {
                    return false;
                }
                PsiType otherParamType = otherParameters[i].getType();
                PsiType myParamType = myParameters[i].getType();
                if (!(myParamType == null || otherParamType == null ? myParamType != null || otherParamType != null : !otherParamType.isAssignableFrom(myParamType))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type);
    }

    public boolean equalsToText(@NonNls String text) {
        return text.equals("groovy.lang.Closure");
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.getLanguageLevel must not return null");
        }
        return languageLevel;
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        return GrClosureType.create(this.mySignature, this.myManager, this.myScope, languageLevel);
    }

    public static GrClosureType create(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.create must not be null");
        }
        return GrClosureType.create(GrClosureSignatureUtil.createSignature(closure), closure.getManager(), closure.getResolveScope(), LanguageLevel.JDK_1_5);
    }

    public static GrClosureType create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.create must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.create must not be null");
        }
        return GrClosureType.create(GrClosureSignatureUtil.createSignature(method, substitutor), method.getManager(), GlobalSearchScope.allScope((Project)method.getProject()), LanguageLevel.JDK_1_5);
    }

    public static GrClosureType create(@NotNull PsiParameter[] parameters, @Nullable PsiType returnType, PsiManager manager, GlobalSearchScope scope, LanguageLevel languageLevel) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.create must not be null");
        }
        return GrClosureType.create(GrClosureSignatureUtil.createSignature(parameters, returnType), manager, scope, languageLevel);
    }

    public static GrClosureType create(@NotNull GrClosureSignature signature, PsiManager manager, GlobalSearchScope scope, LanguageLevel languageLevel) {
        if (signature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.create must not be null");
        }
        return new GrClosureType(languageLevel, scope, manager, signature);
    }

    @Nullable
    public PsiType curry(int count) {
        GrClosureSignature newSignature = this.mySignature.curry(count);
        if (newSignature == null) {
            return null;
        }
        return GrClosureType.create(newSignature, this.myManager, this.myScope, this.myLanguageLevel);
    }

    @NotNull
    public GrClosureSignature getSignature() {
        GrClosureSignature grClosureSignature = this.mySignature;
        if (grClosureSignature == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType.getSignature must not return null");
        }
        return grClosureSignature;
    }

    public PsiType[] getClosureParameterTypes() {
        GrClosureParameter[] parameters = this.mySignature.getParameters();
        PsiType[] types = new PsiType[parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = parameters[i].getType();
        }
        return types;
    }
}

