/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrPostfixExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AfterCallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AssertionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ReadWriteVariableInstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ControlFlowBuilder
extends GroovyRecursiveElementVisitor {
    private List<InstructionImpl> myInstructions;
    private Stack<InstructionImpl> myProcessingStack;
    private PsiConstantEvaluationHelper myConstantEvaluator;
    private Stack<ExceptionInfo> myCatchedExceptionInfos;
    private InstructionImpl myHead;
    private boolean myNegate;
    private boolean myAssertionsOnly;
    private List<Pair<InstructionImpl, GroovyPsiElement>> myPending;
    private GroovyPsiElement myStartInScope;
    private GroovyPsiElement myEndInScope;
    private boolean myIsInScope;
    private int myInstructionNumber;

    public ControlFlowBuilder(Project project) {
        this.myConstantEvaluator = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
    }

    @Override
    public void visitElement(GroovyPsiElement element) {
        if (element == this.myStartInScope) {
            this.myIsInScope = true;
        } else if (element == this.myEndInScope) {
            this.myIsInScope = false;
        }
        if (this.myIsInScope) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitOpenBlock(GrOpenBlock block) {
        GrStatement last;
        GrStatement[] statements;
        PsiElement parent = block.getParent();
        PsiElement lbrace = block.getLBrace();
        if (lbrace != null && parent instanceof GrMethod) {
            GrParameter[] parameters;
            for (GrParameter parameter : parameters = ((GrMethod)parent).getParameters()) {
                this.addNode(new ReadWriteVariableInstructionImpl(parameter, this.myInstructionNumber++));
            }
        }
        super.visitOpenBlock(block);
        if (!(block.getParent() instanceof GrBlockStatement && block.getParent().getParent() instanceof GrLoopStatement || (statements = block.getStatements()).length <= 0 || !((last = statements[statements.length - 1]) instanceof GrExpression))) {
            MaybeReturnInstruction instruction = new MaybeReturnInstruction((GrExpression)last, this.myInstructionNumber++);
            this.checkPending(instruction);
            this.addNode(instruction);
        }
    }

    public Instruction[] buildControlFlow(GroovyPsiElement scope, GroovyPsiElement startInScope, GroovyPsiElement endInScope) {
        this.myInstructions = new ArrayList<InstructionImpl>();
        this.myProcessingStack = new Stack();
        this.myCatchedExceptionInfos = new Stack();
        this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        this.myInstructionNumber = 0;
        this.myStartInScope = startInScope;
        this.myEndInScope = endInScope;
        this.myIsInScope = startInScope == null;
        this.startNode(null);
        if (scope instanceof GrClosableBlock) {
            this.buildFlowForClosure((GrClosableBlock)scope);
        }
        scope.accept(this);
        InstructionImpl end = this.startNode(null);
        this.checkPending(end);
        return this.myInstructions.toArray(new Instruction[this.myInstructions.size()]);
    }

    private void buildFlowForClosure(final GrClosableBlock closure) {
        for (GrParameter parameter : closure.getParameters()) {
            this.addNode(new ReadWriteVariableInstructionImpl(parameter, this.myInstructionNumber++));
        }
        final LinkedHashSet<String> names = new LinkedHashSet<String>();
        closure.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression refExpr) {
                String refName;
                super.visitReferenceExpression(refExpr);
                if (!(refExpr.getQualifierExpression() != null || PsiUtil.isLValue(refExpr) || refExpr.getParent() instanceof GrCall || ControlFlowBuilder.hasDeclaredVariable(refName = refExpr.getReferenceName(), closure, refExpr))) {
                    names.add(refName);
                }
            }
        });
        names.add("owner");
        for (String name : names) {
            this.addNode(new ReadWriteVariableInstructionImpl(name, closure.getLBrace(), this.myInstructionNumber++, true));
        }
        for (PsiElement child = closure.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(this);
        }
    }

    private void addNode(InstructionImpl instruction) {
        this.myInstructions.add(instruction);
        if (this.myHead != null) {
            this.addEdge(this.myHead, instruction);
        }
        this.myHead = instruction;
    }

    void addEdge(InstructionImpl beg, InstructionImpl end) {
        if (!beg.mySucc.contains(end)) {
            beg.mySucc.add(end);
        }
        if (!end.myPred.contains(beg)) {
            end.myPred.add(beg);
        }
    }

    @Override
    public void visitClosure(GrClosableBlock closure) {
    }

    @Override
    public void visitBreakStatement(GrBreakStatement breakStatement) {
        super.visitBreakStatement(breakStatement);
        GrStatement target = breakStatement.findTargetStatement();
        if (target != null && this.myHead != null) {
            this.addPendingEdge(target, this.myHead);
        }
        this.flowAbrupted();
    }

    @Override
    public void visitContinueStatement(GrContinueStatement continueStatement) {
        InstructionImpl instruction;
        super.visitContinueStatement(continueStatement);
        GrStatement target = continueStatement.findTargetStatement();
        if (target != null && this.myHead != null && (instruction = this.findInstruction(target)) != null) {
            this.addEdge(this.myHead, instruction);
        }
        this.flowAbrupted();
    }

    @Override
    public void visitReturnStatement(GrReturnStatement returnStatement) {
        boolean isNodeNeeded = this.myHead == null || this.myHead.getElement() != returnStatement;
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            value.accept(this);
        }
        if (isNodeNeeded) {
            InstructionImpl retInsn = this.startNode(returnStatement);
            this.addPendingEdge(null, this.myHead);
            this.finishNode(retInsn);
        } else {
            this.addPendingEdge(null, this.myHead);
        }
        this.flowAbrupted();
    }

    @Override
    public void visitAssertStatement(GrAssertStatement assertStatement) {
        GrExpression assertion = assertStatement.getAssertion();
        if (assertion != null) {
            assertion.accept(this);
            InstructionImpl assertInstruction = this.startNode(assertStatement);
            PsiClassType type = JavaPsiFacade.getInstance((Project)assertStatement.getProject()).getElementFactory().createTypeByFQClassName("java.lang.AssertionError", assertStatement.getResolveScope());
            ExceptionInfo info = this.findCatch((PsiType)type);
            if (info != null) {
                info.myThrowers.add(assertInstruction);
            } else {
                this.addPendingEdge(null, assertInstruction);
            }
            this.finishNode(assertInstruction);
        }
    }

    @Override
    public void visitThrowStatement(GrThrowStatement throwStatement) {
        GrExpression exception = throwStatement.getException();
        if (exception != null) {
            exception.accept(this);
            InstructionImpl throwInstruction = this.startNode(throwStatement);
            this.flowAbrupted();
            PsiType type = exception.getNominalType();
            if (type != null) {
                ExceptionInfo info = this.findCatch(type);
                if (info != null) {
                    info.myThrowers.add(throwInstruction);
                } else {
                    this.addPendingEdge(null, throwInstruction);
                }
            } else {
                this.addPendingEdge(null, throwInstruction);
            }
            this.finishNode(throwInstruction);
        }
    }

    private void flowAbrupted() {
        this.myHead = null;
    }

    @Nullable
    private ExceptionInfo findCatch(PsiType thrownType) {
        for (int i = this.myCatchedExceptionInfos.size() - 1; i >= 0; --i) {
            PsiType type;
            ExceptionInfo info = (ExceptionInfo)this.myCatchedExceptionInfos.get(i);
            GrCatchClause clause = info.myClause;
            GrParameter parameter = clause.getParameter();
            if (parameter == null || !(type = parameter.getType()).isAssignableFrom(thrownType)) continue;
            return info;
        }
        return null;
    }

    @Override
    public void visitLabeledStatement(GrLabeledStatement labeledStatement) {
        InstructionImpl instruction = this.startNode(labeledStatement);
        super.visitLabeledStatement(labeledStatement);
        this.finishNode(instruction);
    }

    @Override
    public void visitAssignmentExpression(GrAssignmentExpression expression) {
        GrExpression rValue;
        GrExpression lValue = expression.getLValue();
        if (expression.getOperationToken() != GroovyElementTypes.mASSIGN && lValue instanceof GrReferenceExpression) {
            ReadWriteVariableInstructionImpl instruction = new ReadWriteVariableInstructionImpl((GrReferenceExpression)lValue, this.myInstructionNumber++, false);
            this.addNode(instruction);
            this.checkPending(instruction);
        }
        if ((rValue = expression.getRValue()) != null) {
            rValue.accept(this);
            lValue.accept(this);
        }
    }

    @Override
    public void visitParenthesizedExpression(GrParenthesizedExpression expression) {
        expression.getOperand().accept(this);
    }

    @Override
    public void visitUnaryExpression(GrUnaryExpression expression) {
        GrExpression operand = expression.getOperand();
        if (operand != null) {
            this.myNegate = !this.myNegate;
            operand.accept(this);
            this.myNegate = !this.myNegate;
        }
    }

    @Override
    public void visitInstanceofExpression(GrInstanceOfExpression expression) {
        expression.getOperand().accept(this);
        this.addNode(new AssertionInstruction(this.myInstructionNumber++, expression, this.myNegate));
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
        super.visitReferenceExpression(referenceExpression);
        if (referenceExpression.getQualifierExpression() == null) {
            if (this.isIncOrDecOperand(referenceExpression) && !this.myAssertionsOnly) {
                ReadWriteVariableInstructionImpl i = new ReadWriteVariableInstructionImpl(referenceExpression, this.myInstructionNumber++, false);
                this.addNode(i);
                this.addNode(new ReadWriteVariableInstructionImpl(referenceExpression, this.myInstructionNumber++, true));
                this.checkPending(i);
            } else {
                ReadWriteVariableInstructionImpl i = new ReadWriteVariableInstructionImpl(referenceExpression, this.myInstructionNumber++, !this.myAssertionsOnly && PsiUtil.isLValue(referenceExpression));
                this.addNode(i);
                this.checkPending(i);
            }
        }
    }

    private boolean isIncOrDecOperand(GrReferenceExpression referenceExpression) {
        PsiElement parent = referenceExpression.getParent();
        if (parent instanceof GrPostfixExpression) {
            return true;
        }
        if (parent instanceof GrUnaryExpression) {
            IElementType opType = ((GrUnaryExpression)parent).getOperationTokenType();
            return opType == GroovyElementTypes.mDEC || opType == GroovyElementTypes.mINC;
        }
        return false;
    }

    @Override
    public void visitIfStatement(GrIfStatement ifStatement) {
        InstructionImpl ifInstruction = this.startNode(ifStatement);
        GrCondition condition = ifStatement.getCondition();
        InstructionImpl head = this.myHead;
        GrStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch != null) {
            if (condition != null) {
                condition.accept(this);
            }
            thenBranch.accept(this);
            this.addPendingEdge(ifStatement, this.myHead);
        }
        this.myHead = head;
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            if (condition != null) {
                this.myNegate = !this.myNegate;
                boolean old = this.myAssertionsOnly;
                this.myAssertionsOnly = true;
                condition.accept(this);
                this.myNegate = !this.myNegate;
                this.myAssertionsOnly = old;
            }
            elseBranch.accept(this);
            this.addPendingEdge(ifStatement, this.myHead);
        }
        this.finishNode(ifInstruction);
    }

    @Override
    public void visitForStatement(GrForStatement forStatement) {
        GrExpression condition;
        GrForClause clause = forStatement.getClause();
        if (clause instanceof GrTraditionalForClause) {
            for (GrCondition initializer : ((GrTraditionalForClause)clause).getInitialization()) {
                initializer.accept(this);
            }
        } else if (clause instanceof GrForInClause) {
            GrExpression expression = ((GrForInClause)clause).getIteratedExpression();
            if (expression != null) {
                expression.accept(this);
            }
            for (GrVariable variable : clause.getDeclaredVariables()) {
                ReadWriteVariableInstructionImpl writeInsn = new ReadWriteVariableInstructionImpl(variable, this.myInstructionNumber++);
                this.checkPending(writeInsn);
                this.addNode(writeInsn);
            }
        }
        InstructionImpl instruction = this.startNode(forStatement);
        if (clause instanceof GrTraditionalForClause && (condition = ((GrTraditionalForClause)clause).getCondition()) != null) {
            condition.accept(this);
        }
        this.addPendingEdge(forStatement, this.myHead);
        GrStatement body = forStatement.getBody();
        if (body != null) {
            InstructionImpl bodyInstruction = this.startNode(body);
            body.accept(this);
            this.finishNode(bodyInstruction);
        }
        this.checkPending(instruction);
        if (clause instanceof GrTraditionalForClause) {
            for (GrExpression expression : ((GrTraditionalForClause)clause).getUpdate()) {
                expression.accept(this);
            }
        }
        if (this.myHead != null) {
            this.addEdge(this.myHead, instruction);
        }
        this.flowAbrupted();
        this.finishNode(instruction);
    }

    private void checkPending(InstructionImpl instruction) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            for (Pair<InstructionImpl, GroovyPsiElement> pair : this.myPending) {
                this.addEdge((InstructionImpl)pair.getFirst(), instruction);
            }
            this.myPending.clear();
        } else {
            for (int i = this.myPending.size() - 1; i >= 0; --i) {
                Pair<InstructionImpl, GroovyPsiElement> pair = this.myPending.get(i);
                PsiElement scopeWhenToAdd = (PsiElement)pair.getSecond();
                if (scopeWhenToAdd == null) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)element, (boolean)false)) break;
                this.addEdge((InstructionImpl)pair.getFirst(), instruction);
                this.myPending.remove(i);
            }
        }
    }

    private void addPendingEdge(GroovyPsiElement scopeWhenAdded, InstructionImpl instruction) {
        int i;
        if (instruction == null) {
            return;
        }
        if (scopeWhenAdded != null) {
            Pair<InstructionImpl, GroovyPsiElement> pair;
            GroovyPsiElement currScope;
            for (i = 0; i < this.myPending.size() && ((currScope = (GroovyPsiElement)(pair = this.myPending.get(i)).getSecond()) == null || PsiTreeUtil.isAncestor((PsiElement)currScope, (PsiElement)scopeWhenAdded, (boolean)true)); ++i) {
            }
        }
        this.myPending.add(i, (Pair<InstructionImpl, GroovyPsiElement>)new Pair((Object)instruction, (Object)scopeWhenAdded));
    }

    @Override
    public void visitWhileStatement(GrWhileStatement whileStatement) {
        GrStatement body;
        boolean endless;
        InstructionImpl instruction = this.startNode(whileStatement);
        GrCondition condition = whileStatement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if (!(endless = Boolean.TRUE.equals(this.myConstantEvaluator.computeConstantExpression((PsiElement)condition)))) {
            this.addPendingEdge(whileStatement, this.myHead);
        }
        if ((body = whileStatement.getBody()) != null) {
            body.accept(this);
        }
        this.checkPending(instruction);
        if (this.myHead != null) {
            this.addEdge(this.myHead, instruction);
        }
        this.flowAbrupted();
        this.finishNode(instruction);
    }

    @Override
    public void visitSwitchStatement(GrSwitchStatement switchStatement) {
        GrCondition condition = switchStatement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        InstructionImpl instruction = this.startNode(switchStatement);
        for (GrCaseSection section : switchStatement.getCaseSections()) {
            this.myHead = instruction;
            section.accept(this);
        }
        this.finishNode(instruction);
    }

    @Override
    public void visitTryStatement(GrTryCatchStatement tryCatchStatement) {
        GrOpenBlock tryBlock = tryCatchStatement.getTryBlock();
        GrCatchClause[] catchClauses = tryCatchStatement.getCatchClauses();
        GrFinallyClause finallyClause = tryCatchStatement.getFinallyClause();
        for (int i = catchClauses.length - 1; i >= 0; --i) {
            this.myCatchedExceptionInfos.push(new ExceptionInfo(catchClauses[i]));
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> oldPending = null;
        if (finallyClause != null) {
            oldPending = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        }
        InstructionImpl tryBeg = null;
        InstructionImpl tryEnd = null;
        if (tryBlock != null) {
            tryBeg = this.startNode(tryBlock);
            tryBlock.accept(this);
            tryEnd = this.myHead;
            this.finishNode(tryBeg);
        }
        InstructionImpl[][] throwers = new InstructionImpl[catchClauses.length][];
        for (int i = 0; i < catchClauses.length; ++i) {
            List<InstructionImpl> list = this.myCatchedExceptionInfos.pop().myThrowers;
            throwers[i] = list.toArray(new InstructionImpl[list.size()]);
        }
        InstructionImpl[] catches = new InstructionImpl[catchClauses.length];
        for (int i = 0; i < catchClauses.length; ++i) {
            this.flowAbrupted();
            InstructionImpl catchBeg = this.startNode(catchClauses[i]);
            for (InstructionImpl thrower : throwers[i]) {
                this.addEdge(thrower, catchBeg);
            }
            if (tryBeg != null) {
                this.addEdge(tryBeg, catchBeg);
            }
            if (tryEnd != null) {
                this.addEdge(tryEnd, catchBeg);
            }
            catchClauses[i].accept(this);
            catches[i] = this.myHead;
            this.finishNode(catchBeg);
        }
        if (finallyClause != null) {
            this.flowAbrupted();
            InstructionImpl finallyInstruction = this.startNode(finallyClause, false);
            LinkedHashSet<PostCallInstructionImpl> postCalls = new LinkedHashSet<PostCallInstructionImpl>();
            this.addFinallyEdges(finallyInstruction, postCalls);
            if (tryEnd != null) {
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, tryEnd));
            }
            for (InstructionImpl catchEnd : catches) {
                if (catchEnd == null) continue;
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, catchEnd));
            }
            this.myHead = finallyInstruction;
            finallyClause.accept(this);
            RetInstruction retInsn = new RetInstruction(this.myInstructionNumber++);
            for (PostCallInstructionImpl postCall : postCalls) {
                postCall.setReturnInstruction(retInsn);
                this.addEdge(retInsn, postCall);
            }
            this.addNode(retInsn);
            this.flowAbrupted();
            this.finishNode(finallyInstruction);
            assert (oldPending != null);
            oldPending.addAll(this.myPending);
            this.myPending = oldPending;
        } else if (tryEnd != null) {
            this.addPendingEdge(tryCatchStatement, tryEnd);
        }
    }

    private PostCallInstructionImpl addCallNode(InstructionImpl finallyInstruction, GroovyPsiElement scopeWhenAddPending, InstructionImpl src) {
        this.flowAbrupted();
        CallInstructionImpl call = new CallInstructionImpl(this.myInstructionNumber++, finallyInstruction);
        this.addNode(call);
        this.addEdge(call, finallyInstruction);
        this.addEdge(src, call);
        PostCallInstructionImpl postCall = new PostCallInstructionImpl(this.myInstructionNumber++, call);
        this.addNode(postCall);
        this.addPendingEdge(scopeWhenAddPending, postCall);
        return postCall;
    }

    private void addFinallyEdges(InstructionImpl finallyInstruction, Set<PostCallInstructionImpl> calls) {
        List<Pair<InstructionImpl, GroovyPsiElement>> copy = this.myPending;
        this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        for (Pair<InstructionImpl, GroovyPsiElement> pair : copy) {
            calls.add(this.addCallNode(finallyInstruction, (GroovyPsiElement)pair.getSecond(), (InstructionImpl)pair.getFirst()));
        }
    }

    private InstructionImpl startNode(GroovyPsiElement element) {
        return this.startNode(element, true);
    }

    private InstructionImpl startNode(GroovyPsiElement element, boolean checkPending) {
        InstructionImpl instruction = new InstructionImpl(element, this.myInstructionNumber++);
        this.addNode(instruction);
        if (checkPending) {
            this.checkPending(instruction);
        }
        return this.myProcessingStack.push(instruction);
    }

    private void finishNode(InstructionImpl instruction) {
        assert (instruction.equals(this.myProcessingStack.pop()));
    }

    @Override
    public void visitField(GrField field) {
    }

    @Override
    public void visitParameter(GrParameter parameter) {
    }

    @Override
    public void visitMethod(GrMethod method) {
    }

    @Override
    public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
    }

    @Override
    public void visitVariable(GrVariable variable) {
        super.visitVariable(variable);
        if (variable.getInitializerGroovy() != null) {
            ReadWriteVariableInstructionImpl writeInsn = new ReadWriteVariableInstructionImpl(variable, this.myInstructionNumber++);
            this.checkPending(writeInsn);
            this.addNode(writeInsn);
        }
    }

    private InstructionImpl findInstruction(PsiElement element) {
        for (int i = this.myProcessingStack.size() - 1; i >= 0; --i) {
            InstructionImpl instruction = (InstructionImpl)this.myProcessingStack.get(i);
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    private static boolean hasDeclaredVariable(String name, GrClosableBlock scope, PsiElement place) {
        PsiElement prev = null;
        while (place != null) {
            if (place instanceof GrCodeBlock) {
                GrStatement[] statements;
                for (GrStatement statement : statements = ((GrCodeBlock)place).getStatements()) {
                    GrVariable[] variables;
                    if (statement == prev) break;
                    if (!(statement instanceof GrVariableDeclaration)) continue;
                    for (GrVariable variable : variables = ((GrVariableDeclaration)statement).getVariables()) {
                        if (!name.equals(variable.getName())) continue;
                        return true;
                    }
                }
            }
            if (place == scope) break;
            prev = place;
            place = place.getParent();
        }
        return false;
    }

    class RetInstruction
    extends InstructionImpl {
        RetInstruction(int num) {
            super(null, num);
        }

        @Override
        public String toString() {
            return super.toString() + " RETURN";
        }

        @Override
        protected String getElementPresentation() {
            return "";
        }

        @Override
        public Iterable<? extends Instruction> succ(CallEnvironment env) {
            Stack<CallInstruction> callStack = this.getStack(env, this);
            if (callStack.isEmpty()) {
                return Collections.emptyList();
            }
            CallInstruction callInstruction = callStack.peek();
            ArrayList succ = ((CallInstructionImpl)callInstruction).mySucc;
            Stack copy = (Stack)callStack.clone();
            copy.pop();
            for (InstructionImpl instruction : succ) {
                env.update(copy, instruction);
            }
            return succ;
        }
    }

    class PostCallInstructionImpl
    extends InstructionImpl
    implements AfterCallInstruction {
        private final CallInstructionImpl myCall;
        private RetInstruction myReturnInsn;

        @Override
        public String toString() {
            return super.toString() + "AFTER CALL " + this.myCall.num();
        }

        @Override
        public Iterable<? extends Instruction> allPred() {
            return Collections.singletonList(this.myReturnInsn);
        }

        @Override
        public Iterable<? extends Instruction> pred(CallEnvironment env) {
            this.getStack(env, this.myReturnInsn).push(this.myCall);
            return Collections.singletonList(this.myReturnInsn);
        }

        @Override
        protected String getElementPresentation() {
            return "";
        }

        PostCallInstructionImpl(int num, CallInstructionImpl call) {
            super(null, num);
            this.myCall = call;
        }

        public void setReturnInstruction(RetInstruction retInstruction) {
            this.myReturnInsn = retInstruction;
        }
    }

    class CallInstructionImpl
    extends InstructionImpl
    implements CallInstruction {
        private final InstructionImpl myCallee;

        @Override
        public String toString() {
            return super.toString() + " CALL " + this.myCallee.num();
        }

        @Override
        public Iterable<? extends Instruction> succ(CallEnvironment env) {
            this.getStack(env, this.myCallee).push(this);
            return Collections.singletonList(this.myCallee);
        }

        @Override
        public Iterable<? extends Instruction> allSucc() {
            return Collections.singletonList(this.myCallee);
        }

        @Override
        protected String getElementPresentation() {
            return "";
        }

        CallInstructionImpl(int num, InstructionImpl callee) {
            super(null, num);
            this.myCallee = callee;
        }
    }

    private class ExceptionInfo {
        GrCatchClause myClause;
        List<InstructionImpl> myThrowers = new ArrayList<InstructionImpl>();

        private ExceptionInfo(GrCatchClause clause) {
            this.myClause = clause;
        }
    }
}

