/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyFlexLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GroovyLexer
extends LookAheadLexer {
    private static final TokenSet tokensToMerge = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSL_COMMENT, GroovyTokenTypes.mML_COMMENT, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mWS});

    public GroovyLexer() {
        super((Lexer)new MergingLexerAdapter((Lexer)new GroovyFlexLexer(), tokensToMerge));
    }

    protected void lookAhead(Lexer baseLexer) {
        IElementType type = baseLexer.getTokenType();
        if (type == GroovyTokenTypes.mDOT || type == GroovyTokenTypes.kIMPORT || type == GroovyTokenTypes.kPACKAGE) {
            this.addToken(type);
            baseLexer.advance();
            while (baseLexer.getTokenType() == GroovyTokenTypes.mWS) {
                this.addToken(GroovyTokenTypes.mWS);
                baseLexer.advance();
            }
            IElementType token = baseLexer.getTokenType();
            if (token == GroovyTokenTypes.kDEF || token == GroovyTokenTypes.kAS || token == GroovyTokenTypes.kIN) {
                this.addToken(GroovyTokenTypes.mIDENT);
                baseLexer.advance();
            } else {
                this.addToken(token);
                baseLexer.advance();
            }
        } else {
            super.lookAhead(baseLexer);
        }
    }
}

