/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineRange;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.Mover;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class LineMover
extends Mover {
    public LineMover(boolean isDown) {
        super(isDown);
    }

    @Override
    protected boolean checkAvailable(Editor editor, PsiFile file) {
        LineRange range;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int startLine = editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).line;
            LogicalPosition endPos = editor.offsetToLogicalPosition(selectionModel.getSelectionEnd());
            int endLine = endPos.column == 0 ? endPos.line : endPos.line + 1;
            range = new LineRange(startLine, endLine);
        } else {
            int startLine = editor.getCaretModel().getLogicalPosition().line;
            int endLine = startLine + 1;
            range = new LineRange(startLine, endLine);
        }
        int maxLine = editor.offsetToLogicalPosition((int)editor.getDocument().getTextLength()).line;
        if (range.startLine == 0 && !this.isDown) {
            return false;
        }
        if (range.endLine > maxLine && this.isDown) {
            return false;
        }
        this.toMove = range;
        this.updateComplementaryRange();
        return true;
    }

    protected final void updateComplementaryRange() {
        int nearLine = this.isDown ? this.toMove.endLine : this.toMove.startLine - 1;
        this.toMove2 = new LineRange(nearLine, nearLine + 1);
    }

    @Nullable
    protected static Pair<PsiElement, PsiElement> getElementRange(Editor editor, PsiFile file, LineRange range) {
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement startingElement = LineMover.firstNonWhiteElement(startOffset, file, true, true);
        if (startingElement == null) {
            return null;
        }
        int endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)) - 1;
        PsiElement endingElement = LineMover.firstNonWhiteElement(endOffset, file, false, true);
        if (endingElement == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)startingElement, (PsiElement)endingElement, (boolean)false) || startingElement.getTextRange().getEndOffset() <= endingElement.getTextRange().getStartOffset()) {
            return Pair.create((Object)startingElement, (Object)endingElement);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)endingElement, (PsiElement)startingElement, (boolean)false)) {
            return Pair.create((Object)startingElement, (Object)endingElement);
        }
        return null;
    }

    @Nullable
    static PsiElement firstNonWhiteElement(int offset, PsiFile file, boolean lookRight, boolean withNewlines) {
        PsiElement leafElement = file.findElementAt(offset);
        return leafElement == null ? null : LineMover.firstNonWhiteElement(leafElement, lookRight, withNewlines);
    }

    @NotNull
    static PsiElement firstNonWhiteElement(@NotNull PsiElement element, boolean lookRight, boolean withNewlines) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/LineMover.firstNonWhiteElement must not be null");
        }
        while (element instanceof PsiWhiteSpace || StringUtil.isEmptyOrSpaces((String)element.getText()) || PsiUtil.isNewLine(element) && withNewlines) {
            PsiElement candidate;
            PsiElement psiElement = candidate = lookRight ? element.getNextSibling() : element.getPrevSibling();
            if (candidate == null) break;
            element = candidate;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/LineMover.firstNonWhiteElement must not return null");
        }
        return psiElement;
    }

    @Nullable
    protected static Pair<PsiElement, PsiElement> getElementRange(PsiElement parent, PsiElement element1, PsiElement element2) {
        if (PsiTreeUtil.isAncestor((PsiElement)element1, (PsiElement)element2, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)element1, (boolean)false)) {
            return Pair.create((Object)parent, (Object)parent);
        }
        while (element1 != null && element1.getParent() != parent) {
            element1 = element1.getParent();
        }
        while (element2 != null && element2.getParent() != parent) {
            element2 = element2.getParent();
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement commonParent = element1.getParent();
        if ((!(element1 instanceof GrTopStatement) && !(element1 instanceof PsiComment) || !(element2 instanceof GrTopStatement) && !(element2 instanceof PsiComment)) && commonParent == element2.getParent() && commonParent instanceof GrTopStatement) {
            element1 = element2 = element1.getParent();
        }
        if (element1 != element2) assert (element1.getTextRange().getEndOffset() <= element2.getTextRange().getStartOffset()) : element1.getTextRange() + "-" + element2.getTextRange() + element1 + element2;
        return Pair.create((Object)element1, (Object)element2);
    }
}

