/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GrWhileBodyFixer
implements GrFixer {
    @Override
    public void apply(Editor editor, GroovySmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof GrWhileStatement)) {
            return;
        }
        GrWhileStatement whileStatement = (GrWhileStatement)psiElement;
        Document doc = editor.getDocument();
        GrStatement body = whileStatement.getBody();
        if (body instanceof GrBlockStatement) {
            return;
        }
        if (body != null && GrWhileBodyFixer.startLine(doc, body) == GrWhileBodyFixer.startLine(doc, whileStatement) && whileStatement.getCondition() != null) {
            return;
        }
        PsiElement rParenth = whileStatement.getRParenth();
        assert (rParenth != null);
        doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

