/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GrMissingIfStatement
implements GrFixer {
    @Override
    public void apply(Editor editor, GroovySmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        PsiElement rParenth;
        GrStatement thenBranch;
        if (!(psiElement instanceof GrIfStatement)) {
            return;
        }
        GrIfStatement ifStatement = (GrIfStatement)psiElement;
        Document document = editor.getDocument();
        GrStatement elseBranch = ifStatement.getElseBranch();
        PsiElement elseElement = ifStatement.getElseKeyword();
        if (elseElement != null && (elseBranch == null || !(elseBranch instanceof GrBlockStatement) && GrMissingIfStatement.startLine(document, elseBranch) > GrMissingIfStatement.startLine(document, elseElement))) {
            document.insertString(elseElement.getTextRange().getEndOffset(), (CharSequence)"{}");
        }
        if ((thenBranch = ifStatement.getThenBranch()) instanceof GrBlockStatement) {
            return;
        }
        boolean transformingOneLiner = false;
        if (thenBranch != null && GrMissingIfStatement.startLine(document, thenBranch) == GrMissingIfStatement.startLine(document, ifStatement)) {
            if (ifStatement.getCondition() != null) {
                return;
            }
            transformingOneLiner = true;
        }
        if ((rParenth = ifStatement.getRParenth()) == null) {
            return;
        }
        if (elseBranch == null && !transformingOneLiner || thenBranch == null) {
            document.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
        } else {
            document.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{");
            document.insertString(thenBranch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

