/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.control;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class BranchFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        if (context.getParent() != null) {
            PsiElement parent = context.getParent();
            if (parent instanceof GrReferenceExpression && this.treeWalkUp(parent)) {
                PsiElement superParent = parent.getParent();
                if (superParent instanceof GrOpenBlock || superParent instanceof GrCaseSection || superParent instanceof GrClosableBlock) {
                    return true;
                }
                if (superParent instanceof GrWhileStatement) {
                    PsiElement elem;
                    for (elem = parent.getPrevSibling(); elem != null && !GroovyElementTypes.mRPAREN.equals(elem.getNode().getElementType()); elem = elem.getPrevSibling()) {
                    }
                    return elem != null;
                }
            }
            return false;
        }
        return false;
    }

    private boolean treeWalkUp(PsiElement elem) {
        PsiElement parent;
        for (parent = elem.getParent(); !(parent == null || parent instanceof GrWhileStatement || parent instanceof GrForStatement || parent instanceof GrCaseSection); parent = parent.getParent()) {
        }
        return parent != null;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "'break' and 'continue' keywords filter";
    }
}

