/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class GroovySmartCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> INSIDE_EXPRESSION = PlatformPatterns.psiElement().withParent(GrExpression.class);
    private static final TObjectHashingStrategy<TypeConstraint> EXPECTED_TYPE_INFO_STRATEGY = new TObjectHashingStrategy<TypeConstraint>(){

        public int computeHashCode(TypeConstraint object) {
            return object.getType().hashCode();
        }

        public boolean equals(TypeConstraint o1, TypeConstraint o2) {
            return o1.getClass().equals(o2.getClass()) && o1.getType().equals(o2.getType());
        }
    };

    public GroovySmartCompletionContributor() {
        this.extend(CompletionType.SMART, INSIDE_EXPRESSION, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(final @NotNull CompletionParameters params, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (params == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$2.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovySmartCompletionContributor$2.addCompletions must not be null");
                }
                final PsiElement position = params.getPosition();
                if (position.getParent() instanceof GrLiteral) {
                    return;
                }
                final THashSet _infos = new THashSet();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        _infos.addAll(Arrays.asList(GroovySmartCompletionContributor.getExpectedTypes(params)));
                    }
                });
                final Set infos = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<TypeConstraint>>(){

                    public Set<TypeConstraint> compute() {
                        return new THashSet((Collection)_infos, EXPECTED_TYPE_INFO_STRATEGY);
                    }
                });
                PsiElement reference = position.getParent();
                if (reference == null) {
                    return;
                }
                if (reference instanceof GrReferenceElement) {
                    ((GrReferenceElement)reference).processVariants(new Consumer<Object>(){

                        public void consume(Object variant) {
                            PsiType type = null;
                            if (variant instanceof PsiElement) {
                                type = GroovySmartCompletionContributor.getTypeByElement((PsiElement)variant, position);
                            } else if (variant instanceof String && ("true".equals(variant) || "false".equals(variant))) {
                                type = PsiType.BOOLEAN;
                            }
                            if (type == null) {
                                return;
                            }
                            for (TypeConstraint info : infos) {
                                if (!info.satisfied(type, position.getManager(), GlobalSearchScope.allScope((Project)position.getProject()))) continue;
                                LookupElement lookupElement = LookupItemUtil.objectToLookupItem((Object)variant);
                                result.addElement(lookupElement);
                                break;
                            }
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public static TypeConstraint[] getExpectedTypes(CompletionParameters params) {
        PsiElement position = params.getPosition();
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)position, GrExpression.class);
        if (expression != null) {
            return GroovyExpectedTypesProvider.calculateTypeConstraints(expression);
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByElement(PsiElement element, PsiElement context) {
        if (element instanceof PsiType) {
            return (PsiType)element;
        }
        if (element instanceof PsiClass) {
            return PsiType.getJavaLangClass((PsiManager)context.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        if (element instanceof GrExpression) {
            return ((GrExpression)element).getType();
        }
        return null;
    }
}

