/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.StringLiteralPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ConvertStringToGStringIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        StringLiteralPredicate stringLiteralPredicate = new StringLiteralPredicate();
        if (stringLiteralPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertStringToGStringIntention.getElementPredicate must not return null");
        }
        return stringLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertStringToGStringIntention.processIntention must not be null");
        }
        GrLiteral exp = (GrLiteral)element;
        String textString = exp.getText();
        IntentionUtils.replaceExpression(ConvertStringToGStringIntention.convertStringLiteralToGStringLiteral(textString), exp);
    }

    private static String convertStringLiteralToGStringLiteral(String stringLiteral) {
        String contents = stringLiteral.startsWith("'''") ? stringLiteral.substring(3, stringLiteral.length() - 3) : stringLiteral.substring(1, stringLiteral.length() - 1);
        String escaped = ConvertStringToGStringIntention.escape(contents);
        String delimiter = escaped.contains("\n") ? "\"\"\"" : "\"";
        return delimiter + escaped + delimiter;
    }

    private static String escape(String contents) {
        int i;
        StringBuilder out = new StringBuilder();
        char[] chars = contents.toCharArray();
        int len = chars.length - 1;
        for (i = 0; i < len; ++i) {
            if (chars[i] == '\\') {
                if (chars[i + 1] == '\'') {
                    ++i;
                    out.append('\'');
                    continue;
                }
                if (chars[i + 1] == 'n') {
                    out.append('\n');
                    ++i;
                    continue;
                }
                out.append("\\");
                out.append(chars[++i]);
                continue;
            }
            if (chars[i] == '$' || chars[i] == '\"') {
                out.append('\\');
            }
            out.append(chars[i]);
        }
        if (i == len) {
            if (chars[i] == '$' || chars[i] == '\"') {
                out.append('\\');
            }
            out.append(chars[i]);
        }
        return out.toString();
    }
}

