/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertIntegerToDecimalPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ConvertIntegerToDecimalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToDecimalPredicate convertIntegerToDecimalPredicate = new ConvertIntegerToDecimalPredicate();
        if (convertIntegerToDecimalPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToDecimalIntention.getElementPredicate must not return null");
        }
        return convertIntegerToDecimalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        BigInteger val;
        String rawIntString;
        boolean isLong;
        int textLength;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToDecimalIntention.processIntention must not be null");
        }
        GrLiteral exp = (GrLiteral)element;
        String textString = exp.getText();
        char lastChar = textString.charAt((textLength = textString.length()) - 1);
        boolean bl = isLong = lastChar == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        if (textString.startsWith("0x")) {
            rawIntString = textString.substring(2);
            val = new BigInteger(rawIntString, 16);
        } else {
            rawIntString = textString.substring(1);
            val = new BigInteger(rawIntString, 8);
        }
        String decimalString = val.toString(10);
        if (isLong) {
            decimalString = decimalString + 'L';
        }
        IntentionUtils.replaceExpression(decimalString, exp);
    }
}

