/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertibleGStringLiteralPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class ConvertGStringToStringIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertibleGStringLiteralPredicate convertibleGStringLiteralPredicate = new ConvertibleGStringLiteralPredicate();
        if (convertibleGStringLiteralPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertGStringToStringIntention.getElementPredicate must not return null");
        }
        return convertibleGStringLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertGStringToStringIntention.processIntention must not be null");
        }
        GrLiteral exp = (GrLiteral)element;
        IntentionUtils.replaceExpression(ConvertGStringToStringIntention.convertGStringLiteralToStringLiteral(exp), exp);
    }

    private static String convertGStringLiteralToStringLiteral(GrLiteral literal) {
        PsiElement child = literal.getFirstChild();
        if (child == null) {
            return literal.getText();
        }
        ArrayList<String> list = new ArrayList<String>();
        PsiElement prevSibling = null;
        do {
            String text = child.getText();
            PsiElement nextSibling = child.getNextSibling();
            text = child instanceof GrStringInjection ? (((GrStringInjection)child).getClosableBlock() != null ? ConvertGStringToStringIntention.prepareClosableBlock(((GrStringInjection)child).getClosableBlock()) : (((GrStringInjection)child).getReferenceExpression() != null ? ConvertGStringToStringIntention.prepareExpression(((GrStringInjection)child).getReferenceExpression()) : child.getText())) : ConvertGStringToStringIntention.prepareText(text, prevSibling == null, nextSibling == null, nextSibling instanceof GrClosableBlock || nextSibling instanceof GrReferenceExpression);
            if (text != null) {
                list.add(text);
            }
            prevSibling = child;
        } while ((child = child.getNextSibling()) != null);
        StringBuilder builder = new StringBuilder(literal.getTextLength() * 2);
        if (list.size() == 0) {
            return "''";
        }
        builder.append((String)list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            builder.append(" + ").append((String)list.get(i));
        }
        return builder.toString();
    }

    private static String prepareClosableBlock(GrClosableBlock block) {
        GrStatement statement = block.getStatements()[0];
        GrExpression expr = statement instanceof GrReturnStatement ? ((GrReturnStatement)statement).getReturnValue() : (GrExpression)statement;
        return ConvertGStringToStringIntention.prepareExpression(expr);
    }

    private static String prepareExpression(GrExpression expr) {
        String text = expr.getText();
        PsiType type = expr.getType();
        if (type != null && "java.lang.String".equals(type.getCanonicalText())) {
            if (expr instanceof GrBinaryExpression && GroovyTokenTypes.mPLUS.equals(((GrBinaryExpression)expr).getOperationTokenType())) {
                return '(' + text + ')';
            }
            return text;
        }
        return "String.valueOf(" + text + ")";
    }

    @Nullable
    private static String prepareText(String text, boolean isFirst, boolean isLast, boolean isBeforeInjection) {
        if (isFirst) {
            if (text.startsWith("\"\"\"")) {
                text = text.substring(3);
            } else if (text.startsWith("\"")) {
                text = text.substring(1);
            }
        }
        if (isLast) {
            if (text.endsWith("\"\"\"")) {
                text = text.substring(0, text.length() - 3);
            } else if (text.endsWith("\"")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        if (isBeforeInjection) {
            text = text.substring(0, text.length() - 1);
        }
        if (text.length() == 0) {
            return null;
        }
        String escaped = GrStringUtil.escapeSymbolsForString(text, false);
        if (escaped.contains("\n")) {
            escaped = GrStringUtil.escapeSymbolsForGString(escaped, true);
        }
        return GrStringUtil.addQuotes(escaped, false);
    }
}

