/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.intentions.base.ErrorUtil;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

class ImplicitClosureCallPredicate
implements PsiElementPredicate {
    ImplicitClosureCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        GrMethodCallExpression call = (GrMethodCallExpression)element;
        GrExpression invokedExpression = call.getInvokedExpression();
        if (invokedExpression == null) {
            return false;
        }
        PsiType type = invokedExpression.getType();
        if (type == null) {
            return false;
        }
        if (!type.equalsToText("groovy.lang.Closure")) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

