/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ObserverLord<E> {
    private List<E> regularObservers = new ArrayList();
    private List<E> eventQueueObservers = new ArrayList();

    public void addObserver(E observer, boolean inEventQueue) {
        if (!inEventQueue) {
            this.addIfNew(observer, this.regularObservers);
        } else {
            this.addIfNew(observer, this.eventQueueObservers);
        }
    }

    private void addIfNew(E observer, List<E> destinationList) {
        if (!destinationList.contains(observer)) {
            destinationList.add(observer);
        }
    }

    public void removeObserver(E observer) {
        this.regularObservers.remove(observer);
        this.eventQueueObservers.remove(observer);
    }

    public void removeAllObservers() {
        this.regularObservers.clear();
        this.eventQueueObservers.clear();
    }

    public void notifyObservers(ObserverNotification<E> notification) {
        this.notifyObserversInternal(this.regularObservers, notification);
        this.notifyObserversInEventQueueThread(notification);
    }

    private void notifyObserversInEventQueueThread(final ObserverNotification notification) {
        if (this.eventQueueObservers.size() == 0) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.notifyObserversInternal(this.eventQueueObservers, notification);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ObserverLord.this.notifyObserversInternal(ObserverLord.this.eventQueueObservers, notification);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyObserversInternal(List<E> observers, ObserverNotification notification) {
        for (E observer : observers) {
            try {
                notification.notify(observer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.regularObservers.size() + " regular observers, " + this.eventQueueObservers.size() + " event queue observers";
    }

    public static interface ObserverNotification<E> {
        public void notify(E var1);
    }
}

