/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.extensions.completion.ContextSpecificInsertHandler;
import org.jetbrains.plugins.groovy.gant.AntTasksProvider;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;

public class GantPropertiesInsertHandler
implements ContextSpecificInsertHandler {
    private static final Set<String> GANT_SCRIPT_CLOSURE_PROPERTIES = new HashSet();

    @Override
    public boolean isAcceptable(InsertionContext context, int startOffset, LookupElement item) {
        PsiFile file = context.getFile();
        Object obj = item.getObject();
        if (!GantUtils.isGantScriptFile(file)) {
            return false;
        }
        if (obj instanceof PsiMethod) {
            return true;
        }
        if (obj instanceof String) {
            GrArgumentLabel[] targets;
            String str = (String)obj;
            for (GrArgumentLabel target : targets = GantUtils.getScriptTargets((GroovyFile)file)) {
                String name = target.getName();
                if (name == null || !name.equals(str)) continue;
                return true;
            }
            for (String classsName : AntTasksProvider.getInstance(file.getProject()).getAntTasks()) {
                if (!StringUtil.decapitalize((String)classsName).equals(str)) continue;
                return true;
            }
        }
        return GANT_SCRIPT_CLOSURE_PROPERTIES.contains(item.getLookupString());
    }

    @Override
    public void handleInsert(InsertionContext context, int startOffset, LookupElement item) {
        Object obj = item.getObject();
        String name = null;
        if (obj instanceof String) {
            name = (String)obj;
        }
        if (obj instanceof PsiNamedElement) {
            name = ((PsiNamedElement)obj).getName();
        } else if (obj instanceof GrArgumentLabel) {
            name = ((GrArgumentLabel)obj).getName();
        }
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int offset = startOffset + name.length();
        String text = document.getText();
        if (offset == document.getTextLength() || !text.substring(offset).trim().startsWith("(")) {
            document.insertString(offset, (CharSequence)"()");
        }
        caretModel.moveToOffset(offset + 1);
    }

    static {
        GANT_SCRIPT_CLOSURE_PROPERTIES.add("target");
        GANT_SCRIPT_CLOSURE_PROPERTIES.add("setDefaultTarget");
    }
}

