/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.dsltop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.DelegatedMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovyDslDefaultMembers
implements GdslMembersProvider {
    @Nullable
    public PsiClass findClass(String fqn, GdslMembersHolderConsumer consumer) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)consumer.getProject());
        PsiClass clazz = facade.findClass(fqn, GlobalSearchScope.allScope((Project)consumer.getProject()));
        return clazz;
    }

    public void delegatesTo(@Nullable PsiElement elem, GdslMembersHolderConsumer consumer) {
        GrExpression expr;
        PsiType type;
        if (elem instanceof PsiClass) {
            PsiClass clazz = (PsiClass)elem;
            DelegatedMembersHolder holder = new DelegatedMembersHolder();
            for (PsiMethod psiMethod : clazz.getAllMethods()) {
                if (psiMethod.isConstructor()) continue;
                holder.addMember((PsiMember)psiMethod);
            }
            for (PsiMethod psiMethod : clazz.getAllFields()) {
                holder.addMember((PsiMember)psiMethod);
            }
            consumer.addMemberHolder(holder);
        } else if (elem instanceof GrExpression && (type = (expr = (GrExpression)elem).getType()) instanceof PsiClassType) {
            PsiClassType ctype = (PsiClassType)type;
            this.delegatesTo((PsiElement)ctype.resolve(), consumer);
        }
    }

    public PsiMember add(PsiMember member, GdslMembersHolderConsumer consumer) {
        DelegatedMembersHolder holder = new DelegatedMembersHolder();
        holder.addMember(member);
        consumer.addMemberHolder(holder);
        return member;
    }

    @Nullable
    public GrCall enclosingCall(String name, GdslMembersHolderConsumer consumer) {
        PsiElement place = consumer.getPlace();
        if (place == null) {
            return null;
        }
        GrCall call = (GrCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrCall.class, (boolean)true);
        if (call == null) {
            return null;
        }
        while (call != null && !name.equals(GroovyDslDefaultMembers.getInvokedMethodName(call))) {
            call = (GrCall)PsiTreeUtil.getParentOfType((PsiElement)call, GrCall.class, (boolean)true);
        }
        if (call == null) {
            return null;
        }
        GrArgumentList argumentList = call.getArgumentList();
        if (argumentList != null) {
            for (GrExpression grExpression : argumentList.getExpressionArguments()) {
                if (!(grExpression instanceof GrClosableBlock) || PsiTreeUtil.findCommonParent((PsiElement)place, (PsiElement)grExpression) != grExpression) continue;
                return call;
            }
        }
        if (call instanceof GrMethodCallExpression) {
            for (GrExpression grExpression : ((GrMethodCallExpression)call).getClosureArguments()) {
                if (!(grExpression instanceof GrClosableBlock) || PsiTreeUtil.findCommonParent((PsiElement)place, (PsiElement)grExpression) != grExpression) continue;
                return call;
            }
        }
        return null;
    }

    @Nullable
    public PsiMethod enclosingMethod(GdslMembersHolderConsumer consumer) {
        PsiElement place = consumer.getPlace();
        if (place == null) {
            return null;
        }
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)place, PsiMethod.class, (boolean)true);
    }

    @Nullable
    public PsiMember enclosingMember(GdslMembersHolderConsumer consumer) {
        PsiElement place = consumer.getPlace();
        if (place == null) {
            return null;
        }
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)place, PsiMember.class, (boolean)true);
        if (member instanceof PsiClass) {
            return null;
        }
        return member;
    }

    @Nullable
    public PsiClass enclosingClass(GdslMembersHolderConsumer consumer) {
        PsiElement place = consumer.getPlace();
        if (place == null) {
            return null;
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)true);
    }

    @Nullable
    private static String getInvokedMethodName(GrCall call) {
        GrExpression expr;
        GrExpression grExpression = call instanceof GrApplicationStatement ? ((GrApplicationStatement)call).getFunExpression() : (expr = call instanceof GrMethodCallExpression ? ((GrMethodCallExpression)call).getInvokedExpression() : null);
        if (expr instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)expr).getName();
        }
        return null;
    }
}

