/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger.filters;

import com.intellij.execution.filters.StackFrameFilter;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.plugins.groovy.debugger.filters.GroovyDebuggerSettings;

public class GroovyDebuggerClassFilterProvider
extends StackFrameFilter
implements DebuggerClassFilterProvider {
    private static final ClassFilter[] FILTERS = new ClassFilter[]{new ClassFilter("org.codehaus.groovy.*"), new ClassFilter("groovy.*")};

    public List<ClassFilter> getFilters() {
        GroovyDebuggerSettings settings = GroovyDebuggerSettings.getInstance();
        Boolean flag = settings.DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS;
        ArrayList<ClassFilter> list = new ArrayList<ClassFilter>();
        if (flag == null || flag.booleanValue()) {
            list.addAll(Arrays.asList(FILTERS));
            return list;
        }
        return list;
    }

    public boolean isAuxiliaryFrame(String className, String methodName) {
        if (className.equals("org.codehaus.groovy.runtime.DefaultGroovyMethods") || className.equals("org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport")) {
            return false;
        }
        for (ClassFilter filter : FILTERS) {
            String pattern = filter.getPattern();
            if (!className.startsWith(pattern.substring(0, pattern.length() - 1))) continue;
            return true;
        }
        return false;
    }
}

