/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;
import org.jetbrains.plugins.groovy.config.ui.ManagedLibrariesEditor;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyFacetTab
extends FacetEditorTab {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.config.ui.GroovyFacetTab");
    private JPanel myPanel;
    private JPanel myManagedLibrariesPanel;
    private final ManagedLibrariesEditor myManagedLibrariesEditor;

    public GroovyFacetTab(final FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        this.$$$setupUI$$$();
        this.myManagedLibrariesEditor = new ManagedLibrariesEditor(editorContext, validatorsManager, AbstractGroovyLibraryManager.EP_NAME);
        this.myManagedLibrariesPanel.add(this.myManagedLibrariesEditor.getComponent());
        this.myManagedLibrariesEditor.shouldHaveLibrary(new Condition<Library>(){

            public boolean value(Library libraryManager) {
                VirtualFile[] files = editorContext.getLibraryFiles(libraryManager, OrderRootType.CLASSES);
                return LibrariesUtil.getGroovyLibraryHome(files) != null;
            }
        }, "Groovy-containing libraries are missing");
    }

    @Nls
    public String getDisplayName() {
        return GroovyBundle.message("groovy.sdk.configuration", new Object[0]);
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
        this.myManagedLibrariesEditor.updateLibraryList();
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myManagedLibrariesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "Groovy-based frameworks", 0, 0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

