/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ClassUtils {
    public static boolean isSubclass(@Nullable PsiType type, @NonNls String ancestorName) {
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        return ClassUtils.isSubclass(aClass, ancestorName);
    }

    public static boolean isSubclass(@Nullable PsiClass aClass, @NonNls String ancestorName) {
        if (aClass == null) {
            return false;
        }
        Project project = aClass.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass ancestorClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(ancestorName, scope);
        return InheritanceUtil.isCorrectDescendant((PsiClass)aClass, (PsiClass)ancestorClass, (boolean)true);
    }
}

