/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyUntypedAccessInspection
extends BaseInspection {
    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GroovyUntypedAccessInspection.getGroupDisplayName must not return null");
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Access to untyped expression" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GroovyUntypedAccessInspection.getDisplayName must not return null");
        }
        return "Access to untyped expression";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Cannot determine type of '#ref'";
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReferenceExpression(GrReferenceExpression refExpr) {
            GrExpression qualifier;
            super.visitReferenceExpression(refExpr);
            GroovyResolveResult resolveResult = refExpr.advancedResolve();
            PsiElement resolved = resolveResult.getElement();
            if (resolved != null ? GroovyAnnotator.isDeclarationAssignment(refExpr) || resolved instanceof PsiPackage : (qualifier = refExpr.getQualifierExpression()) == null && GroovyAnnotator.isDeclarationAssignment(refExpr)) {
                return;
            }
            PsiType refExprType = refExpr.getType();
            if (refExprType == null) {
                if (resolved != null) {
                    this.registerError(refExpr);
                }
            } else if (refExprType instanceof PsiClassType && ((PsiClassType)refExprType).resolve() == null) {
                this.registerError(refExpr);
            }
        }
    }
}

