/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unassignedVariable;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class UnassignedVariableAccessInspection
extends GroovyLocalInspectionBase {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroovyInspectionBundle.message("groovy.dfa.issues", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/unassignedVariable/UnassignedVariableAccessInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unassigned.access", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/unassignedVariable/UnassignedVariableAccessInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GroovyVariableNotAssigned" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/unassignedVariable/UnassignedVariableAccessInspection.getShortName must not return null");
        }
        return "GroovyVariableNotAssigned";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected void check(GrControlFlowOwner owner, ProblemsHolder problemsHolder) {
        ReadWriteVariableInstruction[] reads;
        Instruction[] flow = owner.getControlFlow();
        for (ReadWriteVariableInstruction read : reads = ControlFlowUtil.getReadsWithoutPriorWrites(flow)) {
            String name;
            GroovyPsiElement property;
            PsiElement element = read.getElement();
            if (!(element instanceof GroovyPsiElement) || (property = ResolveUtil.resolveProperty((GroovyPsiElement)element, name = read.getVariableName())) == null || property instanceof PsiParameter || property instanceof PsiField || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)property, (boolean)false)) continue;
            problemsHolder.registerProblem(element, GroovyInspectionBundle.message("unassigned.access.tooltip", name, ProblemHighlightType.GENERIC_ERROR_OR_WARNING), new LocalQuickFix[0]);
        }
    }
}

