/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public class GroovyInstanceVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        if ("Instance variable naming convention" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/GroovyInstanceVariableNamingConventionInspection.getDisplayName must not return null");
        }
        return "Instance variable naming convention";
    }

    @Override
    protected GroovyFix buildFix(PsiElement location) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return "Instance variable name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            return "Instance variable name '#ref' is too long";
        }
        String string = "Instance variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/GroovyInstanceVariableNamingConventionInspection.buildErrorString must not return null");
        return string2;
    }

    @Override
    protected String getDefaultRegex() {
        return "m_[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(GrField grField) {
            super.visitField(grField);
            if (grField.hasModifierProperty("static")) {
                return;
            }
            String name = grField.getName();
            if (GroovyInstanceVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grField, name);
        }
    }
}

