/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.FormattedTextFieldMacFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.RegExFormatter;
import org.jetbrains.plugins.groovy.codeInspection.utils.RegExInputVerifier;

public abstract class ConventionInspection
extends BaseInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);
    private static final int REGEX_COLUMN_COUNT = 25;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Naming Conventions" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/ConventionInspection.getGroupDisplayName must not return null");
        }
        return "Naming Conventions";
    }

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (length > this.m_maxLength) {
            return false;
        }
        if ("SerialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel patternLabel = new JLabel("Pattern:");
        patternLabel.setHorizontalAlignment(11);
        JLabel minLengthLabel = new JLabel("Min Length:");
        minLengthLabel.setHorizontalAlignment(11);
        JLabel maxLengthLabel = new JLabel("Max Length:");
        maxLengthLabel.setHorizontalAlignment(11);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(2);
        InternationalFormatter formatter = new InternationalFormatter(numberFormat);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        final JFormattedTextField minLengthField = new JFormattedTextField(formatter);
        Font panelFont = panel.getFont();
        minLengthField.setFont(panelFont);
        minLengthField.setValue(this.m_minLength);
        minLengthField.setColumns(2);
        FormattedTextFieldMacFix.apply(minLengthField);
        final JFormattedTextField maxLengthField = new JFormattedTextField(formatter);
        maxLengthField.setFont(panelFont);
        maxLengthField.setValue(this.m_maxLength);
        maxLengthField.setColumns(2);
        FormattedTextFieldMacFix.apply(maxLengthField);
        final JFormattedTextField regexField = new JFormattedTextField(new RegExFormatter());
        regexField.setFont(panelFont);
        regexField.setValue(this.m_regexPattern);
        regexField.setColumns(25);
        regexField.setInputVerifier(new RegExInputVerifier());
        regexField.setFocusLostBehavior(0);
        FormattedTextFieldMacFix.apply(regexField);
        DocumentAdapter listener = new DocumentAdapter(){

            public void textChanged(DocumentEvent evt) {
                try {
                    regexField.commitEdit();
                    minLengthField.commitEdit();
                    maxLengthField.commitEdit();
                    ConventionInspection.this.m_regexPattern = (Pattern)regexField.getValue();
                    ConventionInspection.this.m_regex = ConventionInspection.this.m_regexPattern.pattern();
                    ConventionInspection.this.m_minLength = ((Number)minLengthField.getValue()).intValue();
                    ConventionInspection.this.m_maxLength = ((Number)maxLengthField.getValue()).intValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        };
        Document regexDocument = regexField.getDocument();
        regexDocument.addDocumentListener((DocumentListener)listener);
        Document minLengthDocument = minLengthField.getDocument();
        minLengthDocument.addDocumentListener((DocumentListener)listener);
        Document maxLengthDocument = maxLengthField.getDocument();
        maxLengthDocument.addDocumentListener((DocumentListener)listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        constraints.fill = 2;
        panel.add((Component)patternLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 17;
        panel.add((Component)regexField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        panel.add((Component)minLengthLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        panel.add((Component)minLengthField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.anchor = 13;
        panel.add((Component)maxLengthLabel, constraints);
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.anchor = 17;
        panel.add((Component)maxLengthField, constraints);
        return panel;
    }
}

