/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class CyclomaticComplexityVisitor
extends GroovyRecursiveElementVisitor {
    private int complexity = 1;

    CyclomaticComplexityVisitor() {
    }

    @Override
    public void visitElement(GroovyPsiElement GrElement) {
        int oldComplexity = 0;
        if (GrElement instanceof GrMethod) {
            oldComplexity = this.complexity;
        }
        super.visitElement(GrElement);
        if (GrElement instanceof GrMethod) {
            this.complexity = oldComplexity;
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/metrics/CyclomaticComplexityVisitor.visitForStatement must not be null");
        }
        super.visitForStatement(statement);
        ++this.complexity;
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/metrics/CyclomaticComplexityVisitor.visitIfStatement must not be null");
        }
        super.visitIfStatement(statement);
        ++this.complexity;
    }

    @Override
    public void visitConditionalExpression(GrConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        ++this.complexity;
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement statement) {
        GrCaseSection[] caseClauses;
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/metrics/CyclomaticComplexityVisitor.visitSwitchStatement must not be null");
        }
        super.visitSwitchStatement(statement);
        for (GrCaseSection clause : caseClauses = statement.getCaseSections()) {
            GrStatement[] statements = clause.getStatements();
            if (statements == null || statements.length == 0) continue;
            ++this.complexity;
        }
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/metrics/CyclomaticComplexityVisitor.visitWhileStatement must not be null");
        }
        super.visitWhileStatement(statement);
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }
}

