/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.MyPair;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DItemElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrDynamicImplicitMethod;

public class DMethodElement
extends DItemElement {
    public List<MyPair> myPairs = new ArrayList<MyPair>();
    private PsiMethod myImplicitMethod;

    public DMethodElement() {
        super(null, null, null);
    }

    public DMethodElement(Boolean isStatic, String name, String returnType, List<MyPair> pairs) {
        super(isStatic, name, returnType);
        this.myPairs = pairs;
    }

    public List<MyPair> getPairs() {
        return this.myPairs;
    }

    @Override
    public void clearCache() {
        this.myImplicitMethod = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod getPsi(PsiManager manager, final String containingClassName) {
        PsiMethod psiMethod;
        if (this.myImplicitMethod != null) {
            psiMethod = this.myImplicitMethod;
            if (psiMethod == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/dynamic/elements/DMethodElement.getPsi must not return null");
            return psiMethod;
        }
        String type = this.getType();
        String staticModifier = null;
        Boolean isStatic = this.isStatic();
        if (isStatic != null && isStatic.booleanValue()) {
            staticModifier = "static";
        }
        final String[] argumentsTypes = QuickfixUtil.getArgumentsTypes(this.myPairs);
        GrMethod method = GroovyPsiElementFactory.getInstance(manager.getProject()).createMethodFromText(staticModifier, this.getName(), type, argumentsTypes);
        this.myImplicitMethod = new GrDynamicImplicitMethod(manager, method, containingClassName){

            @Override
            public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
                if (name == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/dynamic/elements/DMethodElement$1.setName must not be null");
                }
                DynamicManager.getInstance(this.getProject()).replaceDynamicMethodName(containingClassName, this.getName(), name, argumentsTypes);
                return super.setName(name);
            }
        };
        psiMethod = this.myImplicitMethod;
        if (psiMethod != null) return psiMethod;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/dynamic/elements/DMethodElement.getPsi must not return null");
    }
}

