/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeEP;

public class GroovyFileTypeLoader
extends FileTypeFactory {
    public static final List<FileType> GROOVY_FILE_TYPES = new ArrayList<FileType>();

    public static FileType[] getGroovyEnabledFileTypes() {
        return GROOVY_FILE_TYPES.toArray(new FileType[GROOVY_FILE_TYPES.size()]);
    }

    public static Set<String> getCustomGroovyScriptExtensions() {
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        strings.add("gdsl");
        for (GroovyScriptTypeEP ep : (GroovyScriptTypeEP[])GroovyScriptType.EP_NAME.getExtensions()) {
            strings.addAll(Arrays.asList(ep.extensions.split(";")));
        }
        return strings;
    }

    public static List<String> getAllGroovyExtensions() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("groovy");
        strings.addAll(GroovyFileTypeLoader.getCustomGroovyScriptExtensions());
        return strings;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/GroovyFileTypeLoader.createFileTypes must not be null");
        }
        consumer.consume((FileType)GroovyFileType.GROOVY_FILE_TYPE, StringUtil.join(GroovyFileTypeLoader.getAllGroovyExtensions(), (String)";"));
        GROOVY_FILE_TYPES.add((FileType)GroovyFileType.GROOVY_FILE_TYPE);
    }
}

