/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompositeCompletionData
extends CompletionData {
    private static boolean ourShouldCompleteReferences = true;
    private static boolean ourShouldCompleteKeywords = true;
    private final CompletionData[] myDataByPriority;

    public CompositeCompletionData(CompletionData ... dataByPriority) {
        this.myDataByPriority = dataByPriority;
    }

    public void addKeywordVariants(final Set<CompletionVariant> set, final PsiElement position, final PsiFile file) {
        if (!ourShouldCompleteKeywords) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                HashSet toAdd = new HashSet();
                block0: for (CompletionData completionData : CompositeCompletionData.this.myDataByPriority) {
                    completionData.addKeywordVariants(toAdd, position, file);
                    for (CompletionVariant completionVariant : toAdd) {
                        if (!completionVariant.hasKeywordCompletions()) continue;
                        break block0;
                    }
                }
                set.addAll(toAdd);
            }
        });
    }

    public static void restrictCompletion(boolean shouldCompleteReferences, boolean shouldCompleteKeywords) {
        ourShouldCompleteReferences = shouldCompleteReferences;
        ourShouldCompleteKeywords = shouldCompleteKeywords;
    }

    public void completeReference(PsiReference reference, Set<LookupElement> set, @NotNull PsiElement position, PsiFile file, int offset) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/CompositeCompletionData.completeReference must not be null");
        }
        if (!ourShouldCompleteReferences) {
            return;
        }
        this.myDataByPriority[0].completeReference(reference, set, position, file, offset);
    }

    public String findPrefix(PsiElement insertedElement, int offset) {
        for (CompletionData completionData : this.myDataByPriority) {
            String prefix = completionData.findPrefix(insertedElement, offset);
            if (prefix.length() <= 0) continue;
            return prefix;
        }
        return "";
    }
}

