/*
 * Decompiled with CFR 0.152.
 */
package org.testng.v6;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.v6.IRunGroupFactory;
import org.testng.v6.Lists;
import org.testng.v6.Maps;
import org.testng.v6.Operation;
import org.testng.v6.RunGroup;
import org.testng.v6.TestPlan;
import org.testng.xml.XmlTest;

public class SuitePlan
implements IRunGroupFactory {
    private Map<RunGroup, Integer> m_runGroups = Maps.newHashMap();
    private int m_currentGroupId = 1;
    private List<TestPlan> m_testPlans = Lists.newArrayList();
    private List<Operation> m_operations;
    private List<ITestNGMethod> m_beforeSuiteMethods = Lists.newArrayList();
    private List<ITestNGMethod> m_afterSuiteMethods = Lists.newArrayList();

    public RunGroup getRunGroup(int type, String name) {
        RunGroup result = new RunGroup(type, name, this.m_currentGroupId);
        Integer id = this.m_runGroups.get(result);
        if (id == null) {
            this.m_runGroups.put(result, new Integer(this.m_currentGroupId));
            ++this.m_currentGroupId;
        } else {
            result.setId(id);
        }
        return result;
    }

    public Integer findRunGroup(int type, String name) {
        return this.m_runGroups.get(new RunGroup(type, name, 0));
    }

    public void init() {
        Iterator<ITestNGMethod> i$ = this.m_beforeSuiteMethods.iterator();
        while (i$.hasNext()) {
            ITestNGMethod m = i$.next();
            this.m_operations.add(this.createOperation(m, this));
        }
    }

    private Operation createOperation(ITestNGMethod m, int affinity, IRunGroupFactory factory, XmlTest xmlTest) {
        Operation result = new Operation(m, factory, xmlTest);
        return result;
    }

    private Operation createOperation(ITestNGMethod m, IRunGroupFactory factory) {
        return this.createOperation(m, 0, factory, null);
    }

    public void dump() {
        this.p("RUN GROUPS:");
        Iterator<Object> i$ = this.m_runGroups.keySet().iterator();
        while (i$.hasNext()) {
            RunGroup rg = i$.next();
            this.p("  " + rg);
        }
        this.p("");
        this.p("PLANS:");
        i$ = this.m_testPlans.iterator();
        while (i$.hasNext()) {
            TestPlan tp = (TestPlan)i$.next();
            this.p(tp.toString());
        }
    }

    private void p(String string) {
        System.out.println(string);
    }

    public void addTestPlan(TestPlan testPlan) {
        testPlan.init(this);
        this.m_testPlans.add(testPlan);
    }
}

